/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.controller;

import com.saas.admin.dto.request.CreatePermissionRequest;
import com.saas.admin.dto.request.UpdatePermissionRequest;
import com.saas.admin.dto.response.PermissionResponse;
import com.saas.admin.entity.Permission;
import com.saas.admin.service.PermissionService;
import com.saas.shared.dto.mapper.PermissionMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/permissions"})
@PreAuthorize(value="hasRole('SYSTEM_ADMIN')")
@Tag(name="Admin Permissions", description="Permission management for RBAC system")
public class AdminPermissionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminPermissionController.class);
    private final PermissionService permissionService;
    private final PermissionMapper permissionMapper;

    @PostMapping
    @Operation(summary="Create permission")
    public ResponseEntity<PermissionResponse> createPermission(@Valid @RequestBody CreatePermissionRequest request) {
        log.info("\ud83d\udcdd Admin creating permission: {}:{}", (Object)request.getResource(), (Object)request.getAction());
        Permission permission = this.permissionService.createPermission(request.getResource(), request.getAction(), request.getDescription(), request.getIsSystem().booleanValue());
        PermissionResponse response = this.permissionMapper.toResponse(permission);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @GetMapping
    @Operation(summary="Get all permissions")
    public ResponseEntity<List<PermissionResponse>> getAllPermissions() {
        List permissions = this.permissionService.getAllPermissions();
        List responses = this.permissionMapper.toResponseList(permissions);
        return ResponseEntity.ok((Object)responses);
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="Get permission by ID")
    public ResponseEntity<PermissionResponse> getPermissionById(@PathVariable Long id) {
        return this.permissionService.getPermissionById(id).map(arg_0 -> ((PermissionMapper)this.permissionMapper).toResponse(arg_0)).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="Update permission")
    public ResponseEntity<PermissionResponse> updatePermission(@PathVariable Long id, @Valid @RequestBody UpdatePermissionRequest request) {
        Permission updated = this.permissionService.updatePermission(id, request.getDescription(), request.getIsActive());
        return ResponseEntity.ok((Object)this.permissionMapper.toResponse(updated));
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Delete permission")
    public ResponseEntity<Void> deletePermission(@PathVariable Long id) {
        this.permissionService.deletePermission(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/resources"})
    @Operation(summary="Get all resources")
    public ResponseEntity<List<String>> getAllResources() {
        return ResponseEntity.ok((Object)this.permissionService.getAllResources());
    }

    @GetMapping(value={"/actions"})
    @Operation(summary="Get all actions")
    public ResponseEntity<List<String>> getAllActions() {
        return ResponseEntity.ok((Object)this.permissionService.getAllActions());
    }

    @Generated
    public AdminPermissionController(PermissionService permissionService, PermissionMapper permissionMapper) {
        this.permissionService = permissionService;
        this.permissionMapper = permissionMapper;
    }
}

