/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.interceptor;

import com.saas.admin.service.TenantSchemaMigrationService;
import com.saas.shared.core.TenantContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TenantMigrationInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantMigrationInterceptor.class);
    @Autowired
    private TenantSchemaMigrationService migrationService;
    private final Set<String> checkedTenants = ConcurrentHashMap.newKeySet();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String tenantId = TenantContext.getTenantId();
        if (tenantId != null && !tenantId.equals("admin") && !this.checkedTenants.contains(tenantId)) {
            try {
                log.debug("Checking schema migration for tenant: {}", (Object)tenantId);
                this.migrationService.migrateIfNeeded(tenantId);
                this.checkedTenants.add(tenantId);
            }
            catch (Exception e) {
                log.error("Failed to check/migrate schema for tenant: {}", (Object)tenantId, (Object)e);
            }
        }
        return true;
    }

    public void clearMigrationCache() {
        this.checkedTenants.clear();
        log.info("Migration check cache cleared. All tenants will be re-checked on next request.");
    }

    public void clearTenantFromCache(String tenantId) {
        this.checkedTenants.remove(tenantId);
        log.info("Tenant '{}' removed from migration cache. Will be re-checked on next request.", (Object)tenantId);
    }
}

