/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.security;

import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class CustomPermissionEvaluator
implements PermissionEvaluator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomPermissionEvaluator.class);

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        if (authentication == null || permission == null) {
            return false;
        }
        return this.hasSimplePermission(authentication, permission.toString());
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        if (authentication == null || targetType == null || permission == null) {
            return false;
        }
        String resource = targetType.toLowerCase();
        String action = permission.toString().toLowerCase();
        String requiredPermission = resource + ":" + action;
        return this.hasSimplePermission(authentication, requiredPermission);
    }

    private boolean hasSimplePermission(Authentication authentication, String requiredPermission) {
        if (authentication == null || authentication.getAuthorities() == null) {
            return false;
        }
        boolean hasPermission = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch(auth -> auth.equals(requiredPermission));
        log.debug("\ud83d\udd10 Permission check: {} \u2192 {}", (Object)requiredPermission, (Object)hasPermission);
        return hasPermission;
    }
}

