/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.security;

import com.saas.shared.security.UserPrincipal;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import jakarta.annotation.PostConstruct;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Date;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenProvider {
    private static final int MINIMUM_SECRET_LENGTH = 32;
    @Value(value="${jwt.secret}")
    private String jwtSecret;
    @Value(value="${jwt.expiration}")
    private long jwtExpiration;

    @PostConstruct
    public void validateSecretOnStartup() {
        this.getSigningKey();
    }

    private SecretKey getSigningKey() {
        if (this.jwtSecret == null || this.jwtSecret.length() < 32) {
            throw new IllegalStateException(String.format("JWT secret must be at least %d characters long. Current length: %d. Generate a secure secret using: openssl rand -base64 32", 32, this.jwtSecret != null ? this.jwtSecret.length() : 0));
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] hashedKey = digest.digest(this.jwtSecret.getBytes(StandardCharsets.UTF_8));
            return Keys.hmacShaKeyFor((byte[])hashedKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate signing key", e);
        }
    }

    public String generateToken(Authentication authentication, String tenantId, String schemaName, String userType) {
        UserPrincipal userPrincipal = (UserPrincipal)authentication.getPrincipal();
        Date now = new Date();
        Date expiryDate = new Date(now.getTime() + this.jwtExpiration);
        return ((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setSubject(userPrincipal.getId().toString())).claim("tenantId", (Object)tenantId).claim("schemaName", (Object)schemaName).claim("userType", (Object)userType).claim("email", (Object)userPrincipal.getEmail()).setIssuedAt(now)).setExpiration(expiryDate)).signWith((Key)this.getSigningKey(), SignatureAlgorithm.HS512).compact();
    }

    public String getUserIdFromToken(String token) {
        Claims claims = (Claims)Jwts.parser().verifyWith(this.getSigningKey()).build().parseSignedClaims((CharSequence)token).getPayload();
        return claims.getSubject();
    }

    public String getTenantIdFromToken(String token) {
        Claims claims = (Claims)Jwts.parser().verifyWith(this.getSigningKey()).build().parseSignedClaims((CharSequence)token).getPayload();
        return (String)claims.get("tenantId", String.class);
    }

    public String getSchemaNameFromToken(String token) {
        Claims claims = (Claims)Jwts.parser().verifyWith(this.getSigningKey()).build().parseSignedClaims((CharSequence)token).getPayload();
        return (String)claims.get("schemaName", String.class);
    }

    public String getUserTypeFromToken(String token) {
        Claims claims = (Claims)Jwts.parser().verifyWith(this.getSigningKey()).build().parseSignedClaims((CharSequence)token).getPayload();
        return (String)claims.get("userType", String.class);
    }

    public boolean validateToken(String authToken) {
        try {
            Jwts.parser().verifyWith(this.getSigningKey()).build().parseSignedClaims((CharSequence)authToken);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

