/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.security;

import com.saas.shared.core.TenantContext;
import com.saas.shared.security.JwtTokenProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class TenantIdentifierFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantIdentifierFilter.class);
    private final JwtTokenProvider jwtTokenProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        try {
            String existingTenant = TenantContext.getTenantId();
            if (existingTenant != null && !existingTenant.isEmpty()) {
                log.debug("\ud83d\udd12 TenantIdentifierFilter: Tenant already set to '{}', skipping JWT extraction for URI: {}", (Object)existingTenant, (Object)request.getRequestURI());
            } else {
                String tenantId = this.extractTenantFromRequest(request);
                if (tenantId != null && !tenantId.isEmpty()) {
                    TenantContext.setTenantId((String)tenantId);
                    log.debug("\ud83d\udd11 TenantIdentifierFilter: Set TenantContext to '{}' for URI: {}", (Object)tenantId, (Object)request.getRequestURI());
                } else {
                    log.debug("\u26a0\ufe0f TenantIdentifierFilter: No tenant found, defaulting to 'saas_db' for URI: {}", (Object)request.getRequestURI());
                }
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            TenantContext.clear();
            log.debug("\ud83e\uddf9 TenantIdentifierFilter: Cleared TenantContext after request");
        }
    }

    private String extractTenantFromRequest(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            try {
                String token = authHeader.substring(7);
                String schemaName = this.jwtTokenProvider.getSchemaNameFromToken(token);
                if (schemaName != null && !schemaName.isEmpty()) {
                    log.debug("\u2705 TenantIdentifierFilter: Extracted tenant '{}' from JWT", (Object)schemaName);
                    return schemaName;
                }
            }
            catch (Exception e) {
                log.warn("\u26a0\ufe0f TenantIdentifierFilter: Failed to extract tenant from JWT: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    @Generated
    public TenantIdentifierFilter(JwtTokenProvider jwtTokenProvider) {
        this.jwtTokenProvider = jwtTokenProvider;
    }
}

