/*
 * Decompiled with CFR 0.152.
 */
package com.saas.tenant.service;

import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.CallCostRecord;
import com.saas.tenant.repository.CallCostRecordRepository;
import jakarta.persistence.EntityManagerFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CallCostTrackingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallCostTrackingService.class);
    private final CallCostRecordRepository callCostRecordRepository;
    private final EntityManagerFactory entityManagerFactory;

    @Transactional
    public CallCostRecord saveCallCost(CallCostRecord costRecord) {
        log.info("\ud83d\udcb0 Saving call cost record - CallSid: {}, Provider: {}, Cost: {} {}", new Object[]{costRecord.getCallSid(), costRecord.getProvider(), costRecord.getCost(), costRecord.getCurrency()});
        Optional existing = this.callCostRecordRepository.findByCallSid(costRecord.getCallSid());
        if (existing.isPresent()) {
            log.info("\ud83d\udcdd Updating existing cost record for CallSid: {}", (Object)costRecord.getCallSid());
            CallCostRecord existingRecord = (CallCostRecord)existing.get();
            existingRecord.setCost(costRecord.getCost());
            existingRecord.setCurrency(costRecord.getCurrency());
            existingRecord.setCallDurationSeconds(costRecord.getCallDurationSeconds());
            existingRecord.setCallEndTime(costRecord.getCallEndTime());
            existingRecord.setCostDetails(costRecord.getCostDetails());
            return (CallCostRecord)this.callCostRecordRepository.save((Object)existingRecord);
        }
        return (CallCostRecord)this.callCostRecordRepository.save((Object)costRecord);
    }

    public CallCostRecord saveInTenantSchema(CallCostRecord costRecord, String tenantSchema) {
        if (tenantSchema == null || tenantSchema.isBlank()) {
            throw new IllegalArgumentException("tenantSchema cannot be null or blank");
        }
        log.info("\ud83c\udd95 Creating MANUAL Hibernate Session for cost record in tenant schema: {}", (Object)tenantSchema);
        Session session = ((SessionFactory)this.entityManagerFactory.unwrap(SessionFactory.class)).withOptions().tenantIdentifier(tenantSchema).openSession();
        try {
            session.beginTransaction();
            log.debug("\u2705 New Hibernate Session created with explicit tenantIdentifier: {}", (Object)tenantSchema);
            CallCostRecord existing = session.createQuery("FROM CallCostRecord WHERE callSid = :callSid", CallCostRecord.class).setParameter("callSid", (Object)costRecord.getCallSid()).uniqueResultOptional().orElse(null);
            if (existing != null) {
                log.info("\ud83d\udcdd Updating existing cost record for CallSid: {}", (Object)costRecord.getCallSid());
                existing.setCost(costRecord.getCost());
                existing.setCurrency(costRecord.getCurrency());
                existing.setCallDurationSeconds(costRecord.getCallDurationSeconds());
                existing.setCallEndTime(costRecord.getCallEndTime());
                existing.setCostDetails(costRecord.getCostDetails());
                session.merge((Object)existing);
                session.getTransaction().commit();
                log.info("\ud83d\udcb0 Cost record updated in TENANT schema '{}' - CallSid: {}, Cost: {} {}", new Object[]{tenantSchema, existing.getCallSid(), existing.getCost(), existing.getCurrency()});
                CallCostRecord callCostRecord = existing;
                return callCostRecord;
            }
            session.persist((Object)costRecord);
            session.flush();
            session.getTransaction().commit();
            log.info("\ud83d\udcb0 Cost record saved to TENANT schema '{}' - CallSid: {}, Cost: {} {}", new Object[]{tenantSchema, costRecord.getCallSid(), costRecord.getCost(), costRecord.getCurrency()});
            CallCostRecord callCostRecord = costRecord;
            return callCostRecord;
        }
        catch (Exception e) {
            if (session.getTransaction() != null && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
            log.error("Error saving cost record to tenant schema '{}' for CallSid: {}", new Object[]{tenantSchema, costRecord.getCallSid(), e});
            throw new RuntimeException("Failed to save cost record to tenant schema: " + tenantSchema, e);
        }
        finally {
            session.close();
            log.debug("\ud83d\udd12 Closed manual Hibernate Session for schema: {}", (Object)tenantSchema);
        }
    }

    @Transactional(readOnly=true)
    public Optional<CallCostRecord> getCallCostByCallSid(String callSid) {
        return this.callCostRecordRepository.findByCallSid(callSid);
    }

    @Transactional(readOnly=true)
    public Map<String, Object> getTenantCostReport(LocalDateTime startDate, LocalDateTime endDate) {
        HashMap<String, Object> report = new HashMap<String, Object>();
        BigDecimal totalCost = this.callCostRecordRepository.getTotalCostBetween(startDate, endDate);
        Long callCount = this.callCostRecordRepository.getCallCountBetween(startDate, endDate);
        List costByProvider = this.callCostRecordRepository.getCostByProviderBetween(startDate, endDate);
        report.put("totalCost", totalCost != null ? totalCost : BigDecimal.ZERO);
        report.put("totalCalls", callCount != null ? callCount : 0L);
        report.put("startDate", startDate);
        report.put("endDate", endDate);
        HashMap<String, BigDecimal> providerCosts = new HashMap<String, BigDecimal>();
        for (Object[] row : costByProvider) {
            String provider = (String)row[0];
            BigDecimal cost = (BigDecimal)row[1];
            providerCosts.put(provider, cost);
        }
        report.put("costByProvider", providerCosts);
        log.info("\ud83d\udcca Cost report generated - Total: {} USD, Calls: {}, Period: {} to {}", new Object[]{totalCost, callCount, startDate, endDate});
        return report;
    }

    @Transactional(readOnly=true)
    public List<CallCostRecord> getAllCostRecords(LocalDateTime startDate, LocalDateTime endDate) {
        return this.callCostRecordRepository.findByCallStartTimeBetween(startDate, endDate);
    }

    @Transactional(readOnly=true)
    public List<CallCostRecord> getCostRecordsByProvider(String provider) {
        return this.callCostRecordRepository.findByProvider(provider);
    }

    @Transactional(readOnly=true)
    public Map<String, Object> getTenantCostSummary(String tenantId, LocalDateTime startDate, LocalDateTime endDate) {
        HashMap summary = new HashMap();
        LocalDateTime start = startDate != null ? startDate : LocalDateTime.now().minusMonths(1L);
        LocalDateTime end = endDate != null ? endDate : LocalDateTime.now();
        return this.getTenantCostReport(start, end);
    }

    @Transactional(readOnly=true)
    public List<CallCostRecord> getCostsByProvider(String provider) {
        return this.callCostRecordRepository.findByProvider(provider);
    }

    @Transactional(readOnly=true)
    public List<CallCostRecord> getCostsByDateRange(LocalDateTime startDate, LocalDateTime endDate) {
        return this.callCostRecordRepository.findByCallStartTimeBetween(startDate, endDate);
    }

    @Transactional(readOnly=true)
    public List<CallCostRecord> getAllCosts() {
        String currentTenant = TenantContext.getTenantId();
        log.debug("\ud83d\udd0d Fetching all costs for tenant schema: {}", (Object)currentTenant);
        return this.callCostRecordRepository.findAll();
    }

    @Generated
    public CallCostTrackingService(CallCostRecordRepository callCostRecordRepository, EntityManagerFactory entityManagerFactory) {
        this.callCostRecordRepository = callCostRecordRepository;
        this.entityManagerFactory = entityManagerFactory;
    }
}

