# 📚 API Documentation - SaaS Multi-Tenant VoIP Platform

## Table des matières
- [🔐 Authentication](#-authentication)
- [📞 Admin - Phone Numbers CRUD](#-admin---phone-numbers-crud)
- [🎛️ Admin - VoIP Configuration](#️-admin---voip-configuration)
- [🔐 Admin - RBAC Roles](#-admin---rbac-roles)
- [🔑 Admin - RBAC Permissions](#-admin---rbac-permissions)
- [💰 Admin - Cost Analytics](#-admin---cost-analytics)
- [💵 Tenant - My Costs](#-tenant---my-costs)
- [📞 Tenant - My Calls](#-tenant---my-calls)
- [📡 Tenant - VoIP Self-Service](#-tenant---voip-self-service)
- [🎙️ VoIP Webhooks](#️-voip-webhooks)
- [📦 Import Insomnia Collection](#-import-insomnia-collection)

---

## 🔐 Authentication

Tous les endpoints (sauf webhooks publics) nécessitent un JWT token dans le header `Authorization: Bearer <token>`.

### **POST** `/api/auth/register`
Créer un nouveau tenant + tenant user (auto-signup).

**⚠️ Note** : Cet endpoint crée automatiquement :
1. Un nouveau **tenant** avec base de données dédiée
2. Un **TENANT_USER** admin pour ce tenant
3. Tables tenant (inbound_call_requests, call_cost_records, etc.)

#### Request Body
```json
{
  "email": "tenant@example.com",
  "password": "securepassword123",
  "firstName": "John",
  "lastName": "Doe",
  "tenantName": "Clinique La Rive Bleue"
}
```

**Champs** :
- `tenantName` : Sera transformé en slug pour le schema (ex: `tenant_clinique_la_rive_bleue`)
- `email` : Email unique (sera le login du tenant user)
- `password` : Minimum 6 caractères

#### Response `200 OK`
```json
{
  "token": "eyJhbGciOiJIUzUxMiJ9...",
  "userType": "TENANT_USER",
  "userId": "123e4567-e89b-12d3-a456-426614174000",
  "tenantId": "tenant_abc123",
  "schemaName": "tenant_clinique_la_rive_bleue"
}
```

**⚠️ Erreurs possibles** :
- `400 BAD REQUEST` : Email déjà utilisé
- `400 BAD REQUEST` : Nom de tenant déjà existant

---

### **POST** `/api/auth/login`
Authentification Admin ou Tenant User.

#### Request Body
```json
{
  "email": "admin@example.com",
  "password": "yourpassword"
}
```

#### Response `200 OK`
```json
{
  "token": "eyJhbGciOiJIUzUxMiJ9...",
  "userType": "SYSTEM_ADMIN",
  "userId": "1",
  "tenantId": null,
  "schemaName": "saas_db"
}
```

**Exemples de login** :
```json
// SYSTEM_ADMIN
{
  "email": "superadmin@system.com",
  "password": "Admin@123"
}

// TENANT_USER
{
  "email": "tenant@example.com",
  "password": "tenant_password"
}
```

---

### 🔧 Créer un SYSTEM_ADMIN (SQL uniquement)

**Il n'y a PAS d'endpoint API** pour créer un SYSTEM_ADMIN. Utilisez le script SQL :

```bash
mysql -u root -p < CREATE_SYSTEM_ADMIN.sql
```

**Credentials par défaut** :
- Email : `superadmin@system.com`
- Password : `Admin@123`

**⚠️ Important** : Changez le mot de passe en production !

---

## 📞 Admin - Phone Numbers CRUD

Endpoints pour gérer les numéros de téléphone (tous providers: Twilio, Telnyx, Ziwo).

### **POST** `/api/admin/phone-numbers`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Créer un nouveau numéro de téléphone.

#### Request Body
```json
{
  "phoneNumber": "+33612345678",
  "tenantId": "tenant_1",
  "provider": "TWILIO",
  "friendlyName": "Clinique La Rive Bleue",
  "isActive": true,
  "description": "Main clinic line for patient appointments"
}
```

#### Response `201 CREATED`
```json
{
  "id": 1,
  "phoneNumber": "+33612345678",
  "tenantId": "tenant_1",
  "provider": "TWILIO",
  "friendlyName": "Clinique La Rive Bleue",
  "isActive": true,
  "description": "Main clinic line for patient appointments",
  "createdAt": "2025-10-17T10:00:00",
  "updatedAt": "2025-10-17T10:00:00"
}
```

---

### **GET** `/api/admin/phone-numbers`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer tous les numéros avec filtres optionnels.

#### Query Parameters (tous optionnels)
- `tenantId`: Filtrer par tenant (ex: `tenant_1`)
- `provider`: Filtrer par provider (ex: `TWILIO`, `ELEVENLABS`, `TELNYX`, `ZIWO`)
- `isActive`: Filtrer par statut actif (`true` / `false`)

#### Exemples
```bash
GET /api/admin/phone-numbers
GET /api/admin/phone-numbers?tenantId=tenant_1
GET /api/admin/phone-numbers?provider=TWILIO
GET /api/admin/phone-numbers?isActive=true
GET /api/admin/phone-numbers?tenantId=tenant_1&provider=TWILIO
```

#### Response `200 OK`
```json
[
  {
    "id": 1,
    "phoneNumber": "+33612345678",
    "tenantId": "tenant_1",
    "provider": "TWILIO",
    "friendlyName": "Clinique La Rive Bleue",
    "isActive": true,
    "description": "Main clinic line",
    "createdAt": "2025-10-17T10:00:00",
    "updatedAt": "2025-10-17T10:00:00"
  }
]
```

---

### **GET** `/api/admin/phone-numbers/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer un numéro spécifique par ID.

#### Response `200 OK` ou `404 NOT FOUND`

---

### **GET** `/api/admin/phone-numbers/tenant/{tenantId}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer tous les numéros d'un tenant.

#### Exemple
```bash
GET /api/admin/phone-numbers/tenant/tenant_1
```

---

### **GET** `/api/admin/phone-numbers/provider/{provider}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer tous les numéros d'un provider.

#### Exemple
```bash
GET /api/admin/phone-numbers/provider/TWILIO
```

---

### **PUT** `/api/admin/phone-numbers/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Mettre à jour un numéro de téléphone.

#### Request Body
```json
{
  "friendlyName": "Updated Clinic Name",
  "description": "Updated description",
  "isActive": true
}
```

#### Response `200 OK` ou `404 NOT FOUND`

---

### **PATCH** `/api/admin/phone-numbers/{id}/deactivate`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Désactiver un numéro de téléphone.

#### Response `200 OK`

---

### **PATCH** `/api/admin/phone-numbers/{id}/activate`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Activer un numéro de téléphone.

#### Response `200 OK`

---

### **DELETE** `/api/admin/phone-numbers/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Supprimer un numéro de téléphone (définitif).

#### Response `204 NO CONTENT`

---

## 🎛️ Admin - VoIP Configuration

Endpoints pour gérer les configurations VoIP par tenant (Telnyx, Twilio, Ziwo).

### **POST** `/api/admin/voip-configs/{tenantId}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Créer une configuration VoIP pour un tenant.

#### Request Body
```json
{
  "provider": "TELNYX",
  "aiAssistantId": "assistant_abc123",
  "aiType": "TELNYX_NATIVE_AI",
  "messagingProfileId": "profile_xyz789",
  "streamUrl": "wss://example.com/stream",
  "isActive": true,
  "metadata": {
    "custom_key": "custom_value"
  }
}
```

#### Response `201 CREATED`
```json
{
  "id": 1,
  "tenantId": "tenant_1",
  "provider": "TELNYX",
  "aiAssistantId": "assistant_abc123",
  "aiType": "TELNYX_NATIVE_AI",
  "messagingProfileId": "profile_xyz789",
  "streamUrl": "wss://example.com/stream",
  "isActive": true,
  "metadata": {
    "custom_key": "custom_value"
  },
  "createdAt": "2025-10-17T10:00:00",
  "updatedAt": "2025-10-17T10:00:00"
}
```

---

### **GET** `/api/admin/voip-configs/{tenantId}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer toutes les configurations VoIP d'un tenant.

#### Response `200 OK`
```json
[
  {
    "id": 1,
    "tenantId": "tenant_1",
    "provider": "TELNYX",
    "aiAssistantId": "assistant_abc123",
    "aiType": "TELNYX_NATIVE_AI",
    "isActive": true
  }
]
```

---

### **GET** `/api/admin/voip-configs/{tenantId}/{provider}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer la configuration VoIP pour un tenant et provider spécifique.

#### Exemple
```bash
GET /api/admin/voip-configs/tenant_1/TELNYX
```

#### Response `200 OK` ou `404 NOT FOUND`

---

### **PUT** `/api/admin/voip-configs/{tenantId}/{provider}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Mettre à jour la configuration VoIP.

#### Request Body
```json
{
  "aiAssistantId": "new_assistant_id",
  "streamUrl": "wss://new-stream.com",
  "isActive": true
}
```

#### Response `200 OK`

---

### **PATCH** `/api/admin/voip-configs/{tenantId}/{provider}/activate`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Activer une configuration VoIP.

#### Response `200 OK`

---

### **PATCH** `/api/admin/voip-configs/{tenantId}/{provider}/deactivate`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Désactiver une configuration VoIP.

#### Response `200 OK`

---

### **DELETE** `/api/admin/voip-configs/{tenantId}/{provider}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Supprimer une configuration VoIP.

#### Response `204 NO CONTENT`

---

## 🔐 Admin - RBAC Roles

Endpoints pour gérer les rôles RBAC (Role-Based Access Control).

### **POST** `/api/admin/roles`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Créer un nouveau rôle.

#### Request Body
```json
{
  "name": "TENANT_ADMIN",
  "description": "Full administrative access to tenant resources",
  "isSystem": false
}
```

#### Response `201 CREATED`
```json
{
  "id": 1,
  "name": "TENANT_ADMIN",
  "description": "Full administrative access to tenant resources",
  "isActive": true,
  "isSystem": false,
  "permissions": [],
  "createdAt": "2025-10-17T10:00:00",
  "updatedAt": "2025-10-17T10:00:00"
}
```

---

### **GET** `/api/admin/roles`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer tous les rôles.

#### Response `200 OK`
```json
[
  {
    "id": 1,
    "name": "TENANT_ADMIN",
    "description": "Full admin access",
    "isActive": true,
    "isSystem": false,
    "permissions": ["tenant:read", "tenant:write", "user:read"]
  }
]
```

---

### **GET** `/api/admin/roles/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer un rôle spécifique avec ses permissions.

#### Response `200 OK`
```json
{
  "id": 1,
  "name": "TENANT_ADMIN",
  "description": "Full admin access",
  "isActive": true,
  "isSystem": false,
  "permissions": ["tenant:read", "tenant:write", "user:read", "voip:read"],
  "createdAt": "2025-10-17T10:00:00",
  "updatedAt": "2025-10-17T10:00:00"
}
```

---

### **PUT** `/api/admin/roles/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Mettre à jour un rôle.

#### Request Body
```json
{
  "description": "Updated description",
  "isActive": true
}
```

#### Response `200 OK`

---

### **DELETE** `/api/admin/roles/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Supprimer un rôle (impossible si des utilisateurs l'ont assigné).

#### Response `204 NO CONTENT` ou `400 BAD REQUEST`

---

### **POST** `/api/admin/roles/{roleId}/permissions`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Assigner des permissions à un rôle.

#### Request Body
```json
{
  "permissionIds": [1, 2, 3, 4]
}
```

#### Response `200 OK`

---

### **DELETE** `/api/admin/roles/{roleId}/permissions/{permissionId}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Retirer une permission d'un rôle.

#### Response `200 OK`

---

## 🔑 Admin - RBAC Permissions

Endpoints pour gérer les permissions granulaires.

### **POST** `/api/admin/permissions`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Créer une nouvelle permission.

#### Request Body
```json
{
  "resource": "tenant",
  "action": "write",
  "description": "Permission to create and update tenants",
  "isSystem": false
}
```

#### Response `201 CREATED`
```json
{
  "id": 1,
  "resource": "tenant",
  "action": "write",
  "permissionString": "tenant:write",
  "description": "Permission to create and update tenants",
  "isActive": true,
  "isSystem": false,
  "createdAt": "2025-10-17T10:00:00"
}
```

---

### **GET** `/api/admin/permissions`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer toutes les permissions.

#### Response `200 OK`
```json
[
  {
    "id": 1,
    "resource": "tenant",
    "action": "read",
    "permissionString": "tenant:read",
    "description": "View tenant information",
    "isActive": true,
    "isSystem": true
  },
  {
    "id": 2,
    "resource": "tenant",
    "action": "write",
    "permissionString": "tenant:write",
    "description": "Create and update tenants",
    "isActive": true,
    "isSystem": false
  }
]
```

---

### **GET** `/api/admin/permissions/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Récupérer une permission spécifique.

#### Response `200 OK` ou `404 NOT FOUND`

---

### **PUT** `/api/admin/permissions/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Mettre à jour une permission (description ou statut actif uniquement).

#### Request Body
```json
{
  "description": "Updated description",
  "isActive": true
}
```

#### Response `200 OK`

---

### **DELETE** `/api/admin/permissions/{id}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Supprimer une permission (impossible si assignée à des rôles).

#### Response `204 NO CONTENT` ou `400 BAD REQUEST`

---

### **GET** `/api/admin/permissions/resources`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Obtenir la liste de toutes les ressources distinctes.

#### Response `200 OK`
```json
["tenant", "user", "voip", "cost", "call"]
```

---

### **GET** `/api/admin/permissions/actions`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Obtenir la liste de toutes les actions distinctes.

#### Response `200 OK`
```json
["read", "write", "delete", "manage"]
```

---

## 💰 Admin - Cost Analytics

Endpoints pour analyser les coûts d'appels (tous tenants, cross-tenant).

### **GET** `/api/admin/costs/tenant/{tenantId}`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Rapport détaillé des coûts pour un tenant spécifique.

#### Query Parameters
- `startDate` (required): Date de début ISO 8601 (ex: `2025-01-01T00:00:00`)
- `endDate` (required): Date de fin ISO 8601 (ex: `2025-12-31T23:59:59`)

#### Exemple
```bash
GET /api/admin/costs/tenant/tenant_1?startDate=2025-01-01T00:00:00&endDate=2025-12-31T23:59:59
```

#### Response `200 OK`
```json
{
  "totalCost": 125.45,
  "totalCalls": 342,
  "startDate": "2025-01-01T00:00:00",
  "endDate": "2025-12-31T23:59:59",
  "costByProvider": {
    "TWILIO": 45.20,
    "ELEVENLABS": 80.25,
    "TELNYX": 0.00
  }
}
```

---

### **GET** `/api/admin/costs/summary`
🔒 Requiert rôle: `SYSTEM_ADMIN`

Vue globale des coûts de tous les tenants.

#### Query Parameters
- `startDate` (optional): Date de début ISO 8601
- `endDate` (optional): Date de fin ISO 8601

#### Exemple
```bash
GET /api/admin/costs/summary?startDate=2025-01-01T00:00:00&endDate=2025-12-31T23:59:59
```

#### Response `200 OK`
```json
{
  "totalCost": 2450.78,
  "totalCalls": 5234,
  "tenantCount": 15,
  "costByProvider": {
    "TWILIO": 980.50,
    "ELEVENLABS": 1320.28,
    "TELNYX": 150.00
  }
}
```

---

## 💵 Tenant - My Costs

Endpoints pour que les tenants consultent leurs propres coûts.

### **GET** `/api/tenant/costs/summary`
🔒 Requiert rôle: `TENANT_USER`

Résumé des coûts du tenant (contexte automatique via JWT).

#### Query Parameters (optionnels)
- `startDate`: Date de début ISO 8601
- `endDate`: Date de fin ISO 8601

#### Exemple
```bash
GET /api/tenant/costs/summary?startDate=2025-01-01T00:00:00&endDate=2025-01-31T23:59:59
```

#### Response `200 OK`
```json
{
  "totalCost": 125.45,
  "totalCalls": 342,
  "startDate": "2025-01-01T00:00:00",
  "endDate": "2025-01-31T23:59:59",
  "costByProvider": {
    "TWILIO": 45.20,
    "ELEVENLABS": 80.25
  }
}
```

---

### **GET** `/api/tenant/costs`
🔒 Requiert rôle: `TENANT_USER`

Liste de tous les coûts avec filtres.

#### Query Parameters (optionnels)
- `provider`: Filtrer par provider (`TWILIO`, `ELEVENLABS`, `TELNYX`)
- `startDate`: Date de début ISO 8601
- `endDate`: Date de fin ISO 8601

#### Exemples
```bash
GET /api/tenant/costs
GET /api/tenant/costs?provider=ELEVENLABS
GET /api/tenant/costs?startDate=2025-01-01T00:00:00&endDate=2025-01-31T23:59:59
```

#### Response `200 OK`
```json
[
  {
    "id": 1,
    "callSid": "CA1234567890abcdef",
    "provider": "ELEVENLABS",
    "callDurationSeconds": 180,
    "cost": 0.45,
    "currency": "USD",
    "costDetails": {
      "sttCost": 0.12,
      "ttsCost": 0.18,
      "llmCost": 0.15
    },
    "callStartTime": "2025-10-17T14:30:00",
    "callEndTime": "2025-10-17T14:33:00",
    "fromNumber": "+33612345678",
    "toNumber": "+33187654321",
    "createdAt": "2025-10-17T14:33:05"
  }
]
```

---

### **GET** `/api/tenant/costs/call/{callSid}`
🔒 Requiert rôle: `TENANT_USER`

Coût d'un appel spécifique.

#### Exemple
```bash
GET /api/tenant/costs/call/CA1234567890abcdef
```

#### Response `200 OK` ou `404 NOT FOUND`

---

### **GET** `/api/tenant/costs/total`
🔒 Requiert rôle: `TENANT_USER`

Coût total (somme) avec filtres optionnels.

#### Query Parameters (optionnels)
- `startDate`: Date de début ISO 8601
- `endDate`: Date de fin ISO 8601

#### Exemple
```bash
GET /api/tenant/costs/total?startDate=2025-01-01T00:00:00&endDate=2025-12-31T23:59:59
```

#### Response `200 OK`
```json
125.45
```

---

### **GET** `/api/tenant/costs/by-provider`
🔒 Requiert rôle: `TENANT_USER`

Coûts groupés par provider.

#### Response `200 OK`
```json
{
  "TWILIO": 45.20,
  "ELEVENLABS": 80.25,
  "TELNYX": 0.00
}
```

---

## 📞 Tenant - My Calls

Endpoints pour consulter les appels et les enregistrements patients.

### **GET** `/api/tenant/calls/inbound`
🔒 Requiert rôle: `TENANT_USER`

Liste paginée des appels entrants.

#### Query Parameters
- `page` (default: 0): Numéro de page (commence à 0)
- `size` (default: 20): Nombre d'éléments par page

#### Exemple
```bash
GET /api/tenant/calls/inbound?page=0&size=20
```

#### Response `200 OK`
```json
{
  "content": [
    {
      "id": 1,
      "callSid": "CA1234567890abcdef",
      "fromNumber": "+33612345678",
      "toNumber": "+33187654321",
      "callStatus": "completed",
      "startTime": "2025-10-17T14:30:00",
      "endTime": "2025-10-17T14:33:00",
      "duration": 180
    }
  ],
  "totalElements": 342,
  "totalPages": 18,
  "size": 20,
  "number": 0
}
```

---

### **GET** `/api/tenant/calls/inbound/{callSid}`
🔒 Requiert rôle: `TENANT_USER`

Détails d'un appel entrant spécifique.

#### Response `200 OK` ou `404 NOT FOUND`

---

### **GET** `/api/tenant/calls/records`
🔒 Requiert rôle: `TENANT_USER`

Liste des enregistrements patients (avec données extraites par AI).

#### Query Parameters (optionnels)
- `provider`: Filtrer par provider
- `startDate`: Date de début ISO 8601
- `endDate`: Date de fin ISO 8601

#### Exemples
```bash
GET /api/tenant/calls/records
GET /api/tenant/calls/records?provider=ELEVENLABS
GET /api/tenant/calls/records?startDate=2025-01-01T00:00:00&endDate=2025-01-31T23:59:59
```

#### Response `200 OK`
```json
[
  {
    "id": 1,
    "callSid": "CA1234567890abcdef",
    "nom": "Jean Dupont",
    "telephone": "+33612345678",
    "dateNaissance": "1985-05-15",
    "maladie": "Diabète type 2",
    "motifVisite": "Consultation de suivi diabète",
    "appointmentDateTime": "2025-10-20T14:30:00",
    "doctorName": "Dr. Martin",
    "appointmentConfirmed": true,
    "smsSent": true,
    "smsStatus": "delivered",
    "conversationTranscript": "[{\"role\":\"assistant\",\"message\":\"Bonjour\"}]",
    "provider": "ELEVENLABS",
    "duration": 180,
    "createdAt": "2025-10-17T14:33:00"
  }
]
```

---

### **GET** `/api/tenant/calls/records/{callSid}`
🔒 Requiert rôle: `TENANT_USER`

Détails d'un enregistrement patient spécifique.

#### Response `200 OK` ou `404 NOT FOUND`

---

### **GET** `/api/tenant/calls/patient/{phoneNumber}`
🔒 Requiert rôle: `TENANT_USER`

Tous les appels d'un patient (recherche par numéro).

#### Exemple
```bash
GET /api/tenant/calls/patient/+33612345678
```

#### Response `200 OK`
```json
[
  {
    "id": 1,
    "callSid": "CA1234567890abcdef",
    "nom": "Jean Dupont",
    "telephone": "+33612345678",
    "appointmentDateTime": "2025-10-20T14:30:00",
    "createdAt": "2025-10-17T14:33:00"
  }
]
```

---

### **GET** `/api/tenant/calls/recent`
🔒 Requiert rôle: `TENANT_USER`

Appels les plus récents (par défaut: 10 derniers).

#### Query Parameters
- `limit` (default: 10): Nombre d'appels

#### Exemple
```bash
GET /api/tenant/calls/recent?limit=5
```

#### Response `200 OK`
```json
[...]
```

---

### **GET** `/api/tenant/calls/statistics`
🔒 Requiert rôle: `TENANT_USER`

Statistiques sur les appels.

#### Query Parameters (optionnels)
- `startDate`: Date de début ISO 8601
- `endDate`: Date de fin ISO 8601

#### Exemple
```bash
GET /api/tenant/calls/statistics?startDate=2025-01-01T00:00:00&endDate=2025-12-31T23:59:59
```

#### Response `200 OK`
```json
{
  "totalCalls": 342,
  "callsWithAppointments": 298,
  "totalDurationSeconds": 61200,
  "averageDurationSeconds": 179
}
```

---

## 📡 Tenant - VoIP Self-Service

Endpoints pour que les tenants gèrent leurs propres configurations VoIP (sans intervention admin).

### **GET** `/api/tenant/voip-configs/{provider}`
🔒 Requiert rôle: `TENANT_USER`

Récupérer la configuration VoIP du tenant pour un provider spécifique.

#### Exemple
```bash
GET /api/tenant/voip-configs/TELNYX
```

#### Response `200 OK`
```json
{
  "tenantId": "tenant_1",
  "provider": "TELNYX",
  "aiAssistantId": "assistant_abc123",
  "aiType": "TELNYX_NATIVE_AI",
  "messagingProfileId": "profile_xyz789",
  "streamUrl": "wss://example.com/stream",
  "isActive": true,
  "fromDatabase": true
}
```

**Note**: `fromDatabase` indique si la config vient de la base de données (`true`) ou des variables d'environnement (`false`).

---

### **PUT** `/api/tenant/voip-configs/{provider}`
🔒 Requiert rôle: `TENANT_USER`

Mettre à jour sa propre configuration VoIP (self-service).

#### Request Body
```json
{
  "aiAssistantId": "new_assistant_id",
  "aiType": "TELNYX_NATIVE_AI",
  "streamUrl": "wss://new-stream.com",
  "isActive": true
}
```

#### Response `200 OK`
```json
{
  "id": 1,
  "tenantId": "tenant_1",
  "provider": "TELNYX",
  "aiAssistantId": "new_assistant_id",
  "aiType": "TELNYX_NATIVE_AI",
  "streamUrl": "wss://new-stream.com",
  "isActive": true,
  "createdAt": "2025-10-17T10:00:00",
  "updatedAt": "2025-10-17T12:30:00"
}
```

---

### **GET** `/api/tenant/voip-configs/{provider}/status`
🔒 Requiert rôle: `TENANT_USER`

Vérifier si le tenant a une configuration VoIP valide.

#### Exemple
```bash
GET /api/tenant/voip-configs/TELNYX/status
```

#### Response `200 OK`
```json
{
  "hasValidConfig": true,
  "configSource": "DATABASE",
  "isActive": true
}
```

**Valeurs possibles** :
- `configSource`: `"DATABASE"` ou `"ENVIRONMENT"`
- `hasValidConfig`: `true` si la config est complète et fonctionnelle

---

## 🎙️ VoIP Webhooks

Endpoints publics (pas d'authentification) pour les webhooks des providers VoIP.

### **POST/GET** `/api/voip/telnyx/texml-response`
Endpoint TeXML pour Telnyx (compatible TwiML).

**Configuration** : Configurer dans Telnyx Portal → Voice → TeXML Applications → Webhook URL

**Headers** : `Content-Type: application/x-www-form-urlencoded`

**Form Data** :
- `From`: Numéro appelant
- `To`: Numéro appelé
- `CallSid`: ID de l'appel
- `CallStatus`: Statut de l'appel

**Response** : XML TeXML
```xml
<?xml version="1.0" encoding="UTF-8"?>
<Response>
  <Start>
    <TelnyxAI assistantId="ai_12345abcde"/>
  </Start>
</Response>
```

**Variables d'environnement requises** :
- `TELNYX_AI_TYPE` : `TELNYX_NATIVE_AI` ou `WEBSOCKET_STREAM`
- `TELNYX_AI_ASSISTANT_ID` : ID de l'assistant Telnyx (si TELNYX_NATIVE_AI)
- `TELNYX_STREAM_URL` : URL WebSocket (si WEBSOCKET_STREAM)

---

### **POST** `/api/voip/incoming-call`
Webhook Twilio pour appels entrants (GET ou POST).

**Headers**: `Content-Type: application/x-www-form-urlencoded`

**Form Data**:
- `From`: Numéro appelant (ex: `+33612345678`)
- `To`: Numéro appelé (ex: `+33187654321`)
- `CallSid`: ID de l'appel Twilio

**Response**: TwiML XML

---

### **POST** `/api/voip/twilio/status-callback`
Webhook Twilio pour capture des coûts d'appel.

**Headers**: `Content-Type: application/x-www-form-urlencoded`

**Form Data**:
- `CallSid`: ID de l'appel
- `CallStatus`: `completed`
- `CallDuration`: Durée en secondes
- `Price`: Coût (ex: `-0.015`)
- `PriceUnit`: `USD`

**Response**: TwiML XML vide

---

### **POST** `/api/voip/elevenlabs/post-call-webhook`
Webhook ElevenLabs pour capture données + coûts après appel.

**Headers**: `Content-Type: application/json`

**Body**:
```json
{
  "call_id": "call_123",
  "call_session_id": "CA1234567890abcdef",
  "transcript": [
    {"role": "assistant", "message": "Bonjour"},
    {"role": "user", "message": "Je voudrais prendre rendez-vous"}
  ],
  "analysis": {
    "evaluation_criteria_results": {
      "Nom": "Jean Dupont",
      "Téléphone": "+33612345678",
      "Rendez-vous confirmé": "Oui - 2025-10-20 14:30",
      "Docteur": "Dr. Martin"
    }
  },
  "metadata": {
    "twilio_phone_number": "+33187654321",
    "twilio_call_sid": "CA1234567890abcdef"
  },
  "subscription_usage": {
    "total_cost": 0.45,
    "currency": "USD"
  },
  "duration_seconds": 180
}
```

**Response**: `200 OK`

---

### **POST** `/api/voip/telnyx/call-end`
Webhook Telnyx pour fin d'appel (déclenche récupération coûts via API).

**Headers**: `Content-Type: application/json`

**Body**:
```json
{
  "call_control_id": "telnyx_call_123",
  "call_leg_id": "leg_123",
  "to": "+33187654321",
  "from": "+33612345678",
  "direction": "incoming",
  "state": "hangup"
}
```

**Response**: `200 OK`

---

## 📦 Import Insomnia Collection

1. **Télécharger** le fichier `API_DOCUMENTATION_INSOMNIA.json`
2. **Ouvrir Insomnia** → Preferences → Data → Import Data
3. **Sélectionner** le fichier JSON
4. **Configurer** les variables d'environnement :
   - `base_url`: `http://localhost:8000` (ou votre URL)
   - `admin_token`: Token JWT Admin (obtenu via `/api/auth/login`)
   - `tenant_token`: Token JWT Tenant (obtenu via `/api/auth/login`)

**Tous les endpoints sont prêts à utiliser !** 🚀

---

## 🔑 Providers Supportés

| Provider | Voice AI | Coûts Trackés | SMS | Description |
|----------|----------|---------------|-----|-------------|
| **Twilio** | OpenAI / ElevenLabs | ✅ | ✅ | Provider principal, flexible |
| **ElevenLabs** | Native AI | ✅ | ❌ | Voice AI conversationnel |
| **Telnyx** | Native AI | ✅ | ✅ | Alternative Twilio |
| **Ziwo** | Native AI | 🟡 | ❌ | En cours d'implémentation |

---

**Documentation générée le 17 Octobre 2025**  
**Version API**: 1.0.0  
**Spring Boot**: 3.5.6
