package com.saas.admin.dto.response;

import com.saas.shared.enums.Provider;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * Response DTO for tenant VoIP configuration
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class VoipConfigResponse {
    
    private Long id;
    private String tenantId;
    private Provider provider;
    private String aiAssistantId;
    private String aiType;
    private String messagingProfileId;
    private String streamUrl;
    private Boolean isActive;
    private String metadata;
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;
}
