package com.saas.shared.config;

import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Configuration
@ConfigurationProperties(prefix = "multitenancy")
@Validated
@Data
public class TenantProperties {
    
    @NotBlank
    private String adminSchema = "saas_db";
    
    @NotBlank
    private String tenantSchemaPrefix = "tenant_";
    
    private int maxTenants = 1000;
    
    private boolean autoCreateSchema = true;
}
