package com.saas.tenant.entity;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.type.SqlTypes;

import java.time.LocalDateTime;

@Entity
@Table(name = "inbound_call_request")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InboundCallRequest {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "call_sid", nullable = false)
    private String callSid;

    @Column(name = "nom")
    private String nom;

    @Column(name = "date_naissance")
    private String dateNaissance;

    @Column(name = "telephone")
    private String telephone;

    @Column(name = "maladie")
    private String maladie;

    @Column(name = "motif_visite", columnDefinition = "TEXT")
    private String motifVisite;

    @Column(name = "appointment_date_time")
    private LocalDateTime appointmentDateTime;

    @Column(name = "doctor_name")
    private String doctorName;

    @Column(name = "appointment_confirmed")
    private Boolean appointmentConfirmed;

    @Column(name = "sms_sent")
    private Boolean smsSent;

    @Column(name = "sms_sid")
    private String smsSid;

    @Column(name = "sms_status")
    private String smsStatus;

    @Column(name = "conversation_transcript", columnDefinition = "JSON")
    @JdbcTypeCode(SqlTypes.JSON)
    private String conversationTranscript;

    @Column(name = "provider", length = 50)
    private String provider;

    @Column(name = "duration")
    private Integer duration;

    @CreationTimestamp
    @Column(name = "created_at", nullable = false, updatable = false)
    private LocalDateTime createdAt;

    @UpdateTimestamp
    @Column(name = "updated_at")
    private LocalDateTime updatedAt;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "call_sid", referencedColumnName = "call_sid", insertable = false, updatable = false)
    private InboundCallData inboundCallData;
}
