/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.entity;

import com.saas.admin.entity.Permission;
import com.saas.admin.entity.Role;
import com.saas.admin.entity.RolePermission;
import com.saas.admin.entity.UserRole;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="roles", schema="saas_db")
public class Role {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, unique=true, length=100)
    private String name;
    @Column(length=500)
    private String description;
    @Column(nullable=false)
    private Boolean isActive;
    @Column(nullable=false)
    private Boolean isSystem;
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<RolePermission> rolePermissions;
    @OneToMany(mappedBy="role", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<UserRole> userRoles;
    @CreationTimestamp
    @Column(nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(nullable=false)
    private LocalDateTime updatedAt;

    public void addPermission(Permission permission) {
        RolePermission rolePermission = RolePermission.builder().role(this).permission(permission).build();
        this.rolePermissions.add(rolePermission);
    }

    public void removePermission(Permission permission) {
        this.rolePermissions.removeIf(rp -> rp.getPermission().equals((Object)permission));
    }

    @Generated
    private static Boolean $default$isActive() {
        return true;
    }

    @Generated
    private static Boolean $default$isSystem() {
        return false;
    }

    @Generated
    private static Set<RolePermission> $default$rolePermissions() {
        return new HashSet<RolePermission>();
    }

    @Generated
    private static Set<UserRole> $default$userRoles() {
        return new HashSet<UserRole>();
    }

    @Generated
    public static RoleBuilder builder() {
        return new RoleBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getIsActive() {
        return this.isActive;
    }

    @Generated
    public Boolean getIsSystem() {
        return this.isSystem;
    }

    @Generated
    public Set<RolePermission> getRolePermissions() {
        return this.rolePermissions;
    }

    @Generated
    public Set<UserRole> getUserRoles() {
        return this.userRoles;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @Generated
    public void setIsSystem(Boolean isSystem) {
        this.isSystem = isSystem;
    }

    @Generated
    public void setRolePermissions(Set<RolePermission> rolePermissions) {
        this.rolePermissions = rolePermissions;
    }

    @Generated
    public void setUserRoles(Set<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Role)) {
            return false;
        }
        Role other = (Role)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$isActive = this.getIsActive();
        Boolean other$isActive = other.getIsActive();
        if (this$isActive == null ? other$isActive != null : !((Object)this$isActive).equals(other$isActive)) {
            return false;
        }
        Boolean this$isSystem = this.getIsSystem();
        Boolean other$isSystem = other.getIsSystem();
        if (this$isSystem == null ? other$isSystem != null : !((Object)this$isSystem).equals(other$isSystem)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set this$rolePermissions = this.getRolePermissions();
        Set other$rolePermissions = other.getRolePermissions();
        if (this$rolePermissions == null ? other$rolePermissions != null : !((Object)this$rolePermissions).equals(other$rolePermissions)) {
            return false;
        }
        Set this$userRoles = this.getUserRoles();
        Set other$userRoles = other.getUserRoles();
        if (this$userRoles == null ? other$userRoles != null : !((Object)this$userRoles).equals(other$userRoles)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Role;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $isActive = this.getIsActive();
        result = result * 59 + ($isActive == null ? 43 : ((Object)$isActive).hashCode());
        Boolean $isSystem = this.getIsSystem();
        result = result * 59 + ($isSystem == null ? 43 : ((Object)$isSystem).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set $rolePermissions = this.getRolePermissions();
        result = result * 59 + ($rolePermissions == null ? 43 : ((Object)$rolePermissions).hashCode());
        Set $userRoles = this.getUserRoles();
        result = result * 59 + ($userRoles == null ? 43 : ((Object)$userRoles).hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Role(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", isActive=" + this.getIsActive() + ", isSystem=" + this.getIsSystem() + ", rolePermissions=" + String.valueOf(this.getRolePermissions()) + ", userRoles=" + String.valueOf(this.getUserRoles()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    @Generated
    public Role() {
        this.isActive = Role.$default$isActive();
        this.isSystem = Role.$default$isSystem();
        this.rolePermissions = Role.$default$rolePermissions();
        this.userRoles = Role.$default$userRoles();
    }

    @Generated
    public Role(Long id, String name, String description, Boolean isActive, Boolean isSystem, Set<RolePermission> rolePermissions, Set<UserRole> userRoles, LocalDateTime createdAt, LocalDateTime updatedAt) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.isActive = isActive;
        this.isSystem = isSystem;
        this.rolePermissions = rolePermissions;
        this.userRoles = userRoles;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
}

