/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.entity;

import com.saas.admin.entity.Permission;
import com.saas.admin.entity.Role;
import com.saas.admin.entity.RolePermission;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="role_permissions", schema="saas_db", uniqueConstraints={@UniqueConstraint(columnNames={"role_id", "permission_id"})})
public class RolePermission {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="role_id", nullable=false)
    private Role role;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="permission_id", nullable=false)
    private Permission permission;
    @CreationTimestamp
    @Column(nullable=false, updatable=false)
    private LocalDateTime assignedAt;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RolePermission)) {
            return false;
        }
        RolePermission that = (RolePermission)o;
        return this.role.getId().equals(that.role.getId()) && this.permission.getId().equals(that.permission.getId());
    }

    public int hashCode() {
        return Objects.hash(this.role.getId(), this.permission.getId());
    }

    @Generated
    public static RolePermissionBuilder builder() {
        return new RolePermissionBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Role getRole() {
        return this.role;
    }

    @Generated
    public Permission getPermission() {
        return this.permission;
    }

    @Generated
    public LocalDateTime getAssignedAt() {
        return this.assignedAt;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setRole(Role role) {
        this.role = role;
    }

    @Generated
    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    @Generated
    public void setAssignedAt(LocalDateTime assignedAt) {
        this.assignedAt = assignedAt;
    }

    @Generated
    public String toString() {
        return "RolePermission(id=" + this.getId() + ", role=" + String.valueOf(this.getRole()) + ", permission=" + String.valueOf(this.getPermission()) + ", assignedAt=" + String.valueOf(this.getAssignedAt()) + ")";
    }

    @Generated
    public RolePermission() {
    }

    @Generated
    public RolePermission(Long id, Role role, Permission permission, LocalDateTime assignedAt) {
        this.id = id;
        this.role = role;
        this.permission = permission;
        this.assignedAt = assignedAt;
    }
}

