/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.repository;

import com.saas.admin.entity.Role;
import com.saas.admin.entity.User;
import com.saas.admin.entity.UserRole;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRoleRepository
extends JpaRepository<UserRole, Long> {
    public List<UserRole> findByUser(User var1);

    @Query(value="SELECT ur FROM UserRole ur JOIN FETCH ur.role WHERE ur.user.id = :userId")
    public List<UserRole> findByUserIdWithRoles(@Param(value="userId") Long var1);

    public List<UserRole> findByRole(Role var1);

    public Optional<UserRole> findByUserAndRole(User var1, Role var2);

    public boolean existsByUserAndRole(User var1, Role var2);

    public void deleteByUser(User var1);

    public void deleteByRole(Role var1);

    @Query(value="SELECT DISTINCT CONCAT(p.resource, ':', p.action) FROM UserRole ur JOIN ur.role r JOIN r.rolePermissions rp JOIN rp.permission p WHERE ur.user = :user AND r.isActive = true AND p.isActive = true")
    public List<String> findAllPermissionsByUser(@Param(value="user") User var1);

    @Query(value="SELECT DISTINCT CONCAT(p.resource, ':', p.action) FROM UserRole ur JOIN ur.role r JOIN r.rolePermissions rp JOIN rp.permission p WHERE ur.user.id = :userId AND r.isActive = true AND p.isActive = true")
    public List<String> findAllPermissionsByUserId(@Param(value="userId") Long var1);

    public long countByRole(Role var1);
}

