/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.shared.enums.Provider;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PhoneNumberService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhoneNumberService.class);
    private final PhoneNumberRepository phoneNumberRepository;

    public PhoneNumber createPhoneNumber(PhoneNumber phoneNumber) {
        log.info("\ud83d\udcde Creating {} phone number: {} for tenant ID: {}", new Object[]{phoneNumber.getProvider(), phoneNumber.getPhoneNumber(), phoneNumber.getTenantId()});
        return (PhoneNumber)this.phoneNumberRepository.save((Object)phoneNumber);
    }

    public Optional<String> getTenantIdByPhoneNumber(String phoneNumber) {
        log.debug("\ud83d\udd0d Looking up tenant for phone number: {}", (Object)phoneNumber);
        return this.phoneNumberRepository.findByPhoneNumberAndIsActive(phoneNumber, Boolean.valueOf(true)).map(PhoneNumber::getTenantId);
    }

    public Optional<String> getTenantIdByPhoneNumber(String phoneNumber, Provider provider) {
        log.debug("\ud83d\udd0d Looking up tenant for {} phone number: {}", (Object)provider, (Object)phoneNumber);
        return this.phoneNumberRepository.findByPhoneNumberAndProvider(phoneNumber, provider).filter(PhoneNumber::getIsActive).map(PhoneNumber::getTenantId);
    }

    public List<PhoneNumber> getPhoneNumbersByTenant(String tenantId) {
        log.debug("\ud83d\udccb Fetching phone numbers for tenant ID: {}", (Object)tenantId);
        return this.phoneNumberRepository.findByTenantId(tenantId);
    }

    public List<PhoneNumber> getPhoneNumbersByTenant(String tenantId, Provider provider) {
        log.debug("\ud83d\udccb Fetching {} phone numbers for tenant ID: {}", (Object)provider, (Object)tenantId);
        return this.phoneNumberRepository.findByTenantIdAndProvider(tenantId, provider);
    }

    public List<PhoneNumber> getAllActivePhoneNumbers() {
        log.debug("\ud83d\udccb Fetching all active phone numbers");
        return this.phoneNumberRepository.findByIsActive(Boolean.valueOf(true));
    }

    public List<PhoneNumber> getPhoneNumbersByActiveStatus(Boolean isActive) {
        log.debug("\ud83d\udccb Fetching phone numbers with isActive={}", (Object)isActive);
        return this.phoneNumberRepository.findByIsActive(isActive);
    }

    public List<PhoneNumber> getAllPhoneNumbersByProvider(Provider provider) {
        log.debug("\ud83d\udccb Fetching all {} phone numbers", (Object)provider);
        return this.phoneNumberRepository.findByProvider(provider);
    }

    public PhoneNumber updatePhoneNumber(Long id, PhoneNumber updates) {
        return this.phoneNumberRepository.findById((Object)id).map(existing -> {
            if (updates.getFriendlyName() != null) {
                existing.setFriendlyName(updates.getFriendlyName());
            }
            if (updates.getDescription() != null) {
                existing.setDescription(updates.getDescription());
            }
            if (updates.getIsActive() != null) {
                existing.setIsActive(updates.getIsActive());
            }
            log.info("\u270f\ufe0f Updated phone number ID: {}", (Object)id);
            return (PhoneNumber)this.phoneNumberRepository.save(existing);
        }).orElseThrow(() -> new RuntimeException("Phone number not found: " + id));
    }

    public void deletePhoneNumber(Long id) {
        log.info("\ud83d\uddd1\ufe0f Deleting phone number ID: {}", (Object)id);
        this.phoneNumberRepository.deleteById((Object)id);
    }

    public void deactivatePhoneNumber(Long id) {
        this.phoneNumberRepository.findById((Object)id).ifPresent(phoneNumber -> {
            phoneNumber.setIsActive(Boolean.valueOf(false));
            this.phoneNumberRepository.save(phoneNumber);
            log.info("\u26d4 Deactivated phone number ID: {}", (Object)id);
        });
    }

    public Optional<PhoneNumber> getPhoneNumberByNumber(String phoneNumber) {
        return this.phoneNumberRepository.findByPhoneNumber(phoneNumber);
    }

    public Optional<PhoneNumber> getPhoneNumberById(Long id) {
        log.debug("\ud83d\udd0d Fetching phone number by ID: {}", (Object)id);
        return this.phoneNumberRepository.findById((Object)id);
    }

    public List<PhoneNumber> getAllPhoneNumbers() {
        log.debug("\ud83d\udccb Fetching all phone numbers");
        return this.phoneNumberRepository.findAll();
    }

    public void activatePhoneNumber(Long id) {
        this.phoneNumberRepository.findById((Object)id).ifPresent(phoneNumber -> {
            phoneNumber.setIsActive(Boolean.valueOf(true));
            this.phoneNumberRepository.save(phoneNumber);
            log.info("\u2705 Activated phone number ID: {}", (Object)id);
        });
    }

    @Generated
    public PhoneNumberService(PhoneNumberRepository phoneNumberRepository) {
        this.phoneNumberRepository = phoneNumberRepository;
    }
}

