/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.admin.dto.request.CreateTenantRequest;
import com.saas.admin.dto.response.TenantResponse;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.TenantRepository;
import com.saas.admin.service.TenantSchemaService;
import com.saas.shared.dto.common.PageResponse;
import com.saas.shared.dto.mapper.TenantMapper;
import com.saas.shared.exception.BusinessException;
import com.saas.shared.exception.ErrorCode;
import com.saas.shared.exception.ResourceNotFoundException;
import com.saas.shared.util.SlugUtils;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantService.class);
    private final TenantRepository tenantRepository;
    private final TenantMapper tenantMapper;
    private final TenantSchemaService tenantSchemaService;

    @Transactional
    public TenantResponse createTenant(CreateTenantRequest request) {
        log.info("Creating tenant: {}", (Object)request.getTenantName());
        String slug = SlugUtils.toSlug((String)request.getTenantName());
        String schemaName = "tenant_" + slug;
        if (this.tenantRepository.existsBySchemaName(schemaName)) {
            throw new BusinessException(ErrorCode.TENANT_ALREADY_EXISTS, "Tenant with name " + request.getTenantName() + " already exists");
        }
        Tenant tenant = this.tenantMapper.toEntity(request);
        tenant.setTenantId(UUID.randomUUID().toString());
        tenant.setSchemaName(schemaName);
        tenant.setStatus(request.getStatus() != null ? request.getStatus() : "ACTIVE");
        Tenant savedTenant = (Tenant)this.tenantRepository.save((Object)tenant);
        log.info("Tenant created successfully with ID: {}", (Object)savedTenant.getTenantId());
        return this.tenantMapper.toResponse(savedTenant);
    }

    @Transactional(readOnly=true)
    public TenantResponse getTenantById(String tenantId) {
        log.debug("Fetching tenant with ID: {}", (Object)tenantId);
        return this.tenantRepository.findByTenantId(tenantId).map(arg_0 -> ((TenantMapper)this.tenantMapper).toResponse(arg_0)).orElseThrow(() -> new ResourceNotFoundException("Tenant", (Object)tenantId));
    }

    @Transactional(readOnly=true)
    public List<TenantResponse> getAllTenants() {
        log.debug("Fetching all tenants");
        return this.tenantMapper.toResponseList(this.tenantRepository.findAll());
    }

    @Transactional(readOnly=true)
    public PageResponse<TenantResponse> getTenants(int page, int size) {
        log.debug("Fetching tenants - page: {}, size: {}", (Object)page, (Object)size);
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        Page tenantPage = this.tenantRepository.findAll((Pageable)pageable);
        return PageResponse.builder().content(this.tenantMapper.toResponseList(tenantPage.getContent())).page(page).size(size).totalElements(tenantPage.getTotalElements()).totalPages(tenantPage.getTotalPages()).hasNext(tenantPage.hasNext()).hasPrevious(tenantPage.hasPrevious()).build();
    }

    @Transactional
    public void deleteTenant(String tenantId) {
        log.info("Deleting tenant with ID: {}", (Object)tenantId);
        Tenant tenant = (Tenant)this.tenantRepository.findByTenantId(tenantId).orElseThrow(() -> new ResourceNotFoundException("Tenant", (Object)tenantId));
        this.tenantRepository.delete((Object)tenant);
        log.info("Tenant deleted successfully with ID: {}", (Object)tenantId);
    }

    @Generated
    public TenantService(TenantRepository tenantRepository, TenantMapper tenantMapper, TenantSchemaService tenantSchemaService) {
        this.tenantRepository = tenantRepository;
        this.tenantMapper = tenantMapper;
        this.tenantSchemaService = tenantSchemaService;
    }
}

