/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.service.InboundCallService;
import com.saas.voip.handler.ElevenLabsSessionHandler;
import com.saas.voip.service.TwilioSmsService;
import java.time.LocalDateTime;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/elevenlabs"})
public class ElevenLabsCallbackController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElevenLabsCallbackController.class);
    private final InboundCallService inboundCallService;
    private final ElevenLabsSessionHandler elevenLabsSessionHandler;
    private final TwilioSmsService twilioSmsService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Value(value="${server.base-url:http://localhost:8000}")
    private String serverBaseUrl;

    @PostMapping(value={"/call-summary"})
    public ResponseEntity<Map<String, Object>> handleCallSummary(@RequestBody Map<String, Object> payload, @RequestParam(required=false) String sessionId) {
        log.info("Received ElevenLabs call summary: {}", payload);
        try {
            Map data;
            String conversationId = null;
            if (payload.containsKey("data") && payload.get("data") instanceof Map && (data = (Map)payload.get("data")).containsKey("conversation_id")) {
                conversationId = data.get("conversation_id").toString();
            }
            String callSid = null;
            if (conversationId != null) {
                callSid = this.elevenLabsSessionHandler.getCallSidByConversationId(conversationId);
                log.info("\ud83d\udcde Found callSid {} for conversation_id {}", (Object)callSid, conversationId);
            }
            if (callSid == null && sessionId != null) {
                callSid = this.elevenLabsSessionHandler.getCallSid(sessionId);
            }
            if (callSid == null && payload.containsKey("call_sid")) {
                callSid = payload.get("call_sid").toString();
            }
            if (callSid != null) {
                Map data2;
                String nom = this.getStringValue(payload, new String[]{"nom", "patient_name"});
                String dateNaissance = this.getStringValue(payload, new String[]{"date_naissance", "birthdate"});
                String telephone = this.getStringValue(payload, new String[]{"telephone", "phone"});
                String maladie = this.getStringValue(payload, new String[]{"maladie", "illness"});
                String motifVisite = this.getStringValue(payload, new String[]{"motif_visite", "visit_reason"});
                String doctorName = this.getStringValue(payload, new String[]{"doctor_name"});
                String appointmentDateTimeStr = this.getStringValue(payload, new String[]{"appointment_date_time", "appointment_datetime"});
                Boolean confirmed = this.getBooleanValue(payload, new String[]{"appointment_confirmed", "confirmed"});
                LocalDateTime appointmentDateTime = null;
                if (appointmentDateTimeStr != null) {
                    try {
                        appointmentDateTime = LocalDateTime.parse(appointmentDateTimeStr);
                    }
                    catch (Exception e) {
                        log.warn("Failed to parse appointment date/time: {}", (Object)appointmentDateTimeStr);
                    }
                }
                InboundCallRequest request = InboundCallRequest.builder().callSid(callSid).nom(nom).dateNaissance(dateNaissance).telephone(telephone).maladie(maladie).motifVisite(motifVisite).appointmentDateTime(appointmentDateTime).doctorName(doctorName).appointmentConfirmed(Boolean.valueOf(confirmed != null && confirmed != false)).smsSent(Boolean.valueOf(false)).build();
                String transcript = null;
                if (conversationId != null && payload.containsKey("data") && payload.get("data") instanceof Map && (data2 = (Map)payload.get("data")).containsKey("transcript")) {
                    transcript = this.objectMapper.writeValueAsString(data2.get("transcript"));
                    log.info("\ud83d\udcdd Extracted transcript from ElevenLabs payload");
                }
                if (transcript == null && conversationId != null) {
                    transcript = this.elevenLabsSessionHandler.getTranscriptByConversationId(conversationId);
                }
                if (transcript == null && sessionId != null) {
                    transcript = this.elevenLabsSessionHandler.getTranscript(sessionId);
                }
                if (transcript != null) {
                    request.setConversationTranscript(transcript);
                }
                InboundCallRequest savedRequest = this.inboundCallService.savePatientRequest(request);
                log.info("Saved ElevenLabs patient data for callSid: {}", (Object)callSid);
                if (Boolean.TRUE.equals(savedRequest.getAppointmentConfirmed()) && savedRequest.getAppointmentDateTime() != null && savedRequest.getTelephone() != null && savedRequest.getDoctorName() != null) {
                    log.info("\ud83d\udcf1 Envoi du SMS de confirmation de RDV...");
                    String statusCallbackUrl = this.serverBaseUrl + "/api/voip/sms/status-callback";
                    String smsSid = this.twilioSmsService.sendAppointmentConfirmationSms(savedRequest.getTelephone(), savedRequest.getNom(), savedRequest.getDoctorName(), savedRequest.getAppointmentDateTime(), statusCallbackUrl);
                    if (smsSid != null) {
                        savedRequest.setSmsSent(Boolean.valueOf(true));
                        savedRequest.setSmsSid(smsSid);
                        savedRequest.setSmsStatus("queued");
                        this.inboundCallService.savePatientRequest(savedRequest);
                        log.info("\u2705 SMS de confirmation envoy\u00e9 (SID: {})", (Object)smsSid);
                    }
                }
                return ResponseEntity.ok(Map.of("status", "success", "saved", true));
            }
            log.warn("No callSid found in ElevenLabs callback");
            return ResponseEntity.badRequest().body(Map.of("error", "Missing callSid"));
        }
        catch (Exception e) {
            log.error("Error processing ElevenLabs callback", (Throwable)e);
            return ResponseEntity.internalServerError().body(Map.of("error", e.getMessage()));
        }
    }

    private String getStringValue(Map<String, Object> payload, String ... keys) {
        for (String key : keys) {
            if (!payload.containsKey(key) || payload.get(key) == null) continue;
            return payload.get(key).toString();
        }
        return null;
    }

    private Boolean getBooleanValue(Map<String, Object> payload, String ... keys) {
        for (String key : keys) {
            if (!payload.containsKey(key) || payload.get(key) == null) continue;
            Object value = payload.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.valueOf(value.toString());
        }
        return null;
    }

    @Generated
    public ElevenLabsCallbackController(InboundCallService inboundCallService, ElevenLabsSessionHandler elevenLabsSessionHandler, TwilioSmsService twilioSmsService) {
        this.inboundCallService = inboundCallService;
        this.elevenLabsSessionHandler = elevenLabsSessionHandler;
        this.twilioSmsService = twilioSmsService;
    }
}

