/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.Provider;
import com.saas.tenant.entity.InboundCallData;
import com.saas.tenant.service.InboundCallService;
import com.saas.voip.extractor.TelnyxCallDataExtractor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/telnyx"})
public class TelnyxVoiceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxVoiceController.class);
    private final TelnyxCallDataExtractor callDataExtractor;
    private final InboundCallService inboundCallService;
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/incoming-call"}, produces={"application/json"})
    public Map<String, Object> handleIncomingCall(HttpServletRequest request, @RequestBody Map<String, Object> payload) {
        log.info("=== TELNYX WEBHOOK RECEIVED ===");
        Map eventData = (Map)payload.get("data");
        String eventType = (String)eventData.get("event_type");
        log.info("\ud83d\udcde Event Type: {}", (Object)eventType);
        if (!"call.initiated".equals(eventType)) {
            log.info("\u23ed\ufe0f Ignoring event type: {}", (Object)eventType);
            return Map.of("status", "ignored", "event_type", eventType);
        }
        Map callPayload = (Map)eventData.get("payload");
        String fromNumber = (String)callPayload.get("from");
        String toNumber = (String)callPayload.get("to");
        String callControlId = (String)callPayload.get("call_control_id");
        String callSessionId = (String)callPayload.get("call_session_id");
        String direction = (String)callPayload.get("direction");
        log.info("\ud83d\udcde Direction: {}, From: {}, To: {}", new Object[]{direction, fromNumber, toNumber});
        log.info("\ud83c\udd94 Call Control ID: {}, Session ID: {}", (Object)callControlId, (Object)callSessionId);
        if (!"incoming".equals(direction)) {
            log.info("\u23ed\ufe0f Ignoring non-incoming call");
            return Map.of("status", "ignored", "direction", direction);
        }
        String schemaName = null;
        String tenantId = null;
        if (toNumber != null) {
            try {
                Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(toNumber);
                if (phoneOpt.isPresent() && ((PhoneNumber)phoneOpt.get()).getProvider() == Provider.TELNYX) {
                    tenantId = ((PhoneNumber)phoneOpt.get()).getTenantId();
                    log.info("\ud83d\udcde Identified Tenant ID: {} for Telnyx number: {}", (Object)tenantId, (Object)toNumber);
                    Optional tenant = this.tenantRepository.findByTenantId(tenantId);
                    if (tenant.isPresent()) {
                        schemaName = ((Tenant)tenant.get()).getSchemaName();
                        log.info("\ud83d\udcca Using schema: {} for tenant: {}", (Object)schemaName, (Object)tenantId);
                    }
                } else {
                    log.warn("\u26a0\ufe0f No Telnyx tenant found for phone number: {}", (Object)toNumber);
                }
            }
            catch (Exception e) {
                log.error("Error looking up tenant", (Throwable)e);
            }
        }
        if (schemaName != null && callSessionId != null) {
            TenantContext.setTenantId(schemaName);
            try {
                InboundCallData callData = this.callDataExtractor.extractFromTelnyxRequest(payload);
                this.inboundCallService.saveCallData(callData);
                log.info("\u2705 Telnyx call data saved to tenant schema: {}", schemaName);
            }
            catch (Exception e) {
                log.error("Error saving Telnyx call data", (Throwable)e);
            }
            finally {
                TenantContext.clear();
            }
        }
        log.warn("\u26a0\ufe0f TELNYX CONFIGURATION REQUIRED:");
        log.warn("   To answer calls and start AI, you need to:");
        log.warn("   1. Use Telnyx Call Control API (not webhook responses)");
        log.warn("   2. Configure TeXML Application in Telnyx Portal");
        log.warn("   3. OR use Telnyx SDK to answer call programmatically");
        log.warn("   Call Control ID: {}", (Object)callControlId);
        return Map.of("status", "received", "call_control_id", callControlId, "message", "Use Telnyx Call Control API or TeXML to handle this call");
    }

    @PostMapping(value={"/call-initiated"}, produces={"application/json"})
    public void handleCallInitiated(@RequestBody Map<String, Object> payload) {
        log.info("\ud83d\udcde Telnyx call initiated event received");
    }

    @PostMapping(value={"/call-answered"}, produces={"application/json"})
    public void handleCallAnswered(@RequestBody Map<String, Object> payload) {
        log.info("\u2705 Telnyx call answered event received");
    }

    @PostMapping(value={"/call-hangup"}, produces={"application/json"})
    public void handleCallHangup(@RequestBody Map<String, Object> payload) {
        log.info("\ud83d\udcf4 Telnyx call hangup event received");
        Map eventData = (Map)payload.get("data");
        Map callPayload = (Map)eventData.get("payload");
        String callSessionId = (String)callPayload.get("call_session_id");
    }

    @GetMapping(value={"/health"})
    public String health() {
        return "Telnyx VoIP Service is running!";
    }

    private String getTelnyxAIAssistantId(String tenantId) {
        String defaultAssistantId = System.getenv("TELNYX_AI_ASSISTANT_ID");
        return defaultAssistantId != null ? defaultAssistantId : "default-assistant";
    }

    @Generated
    public TelnyxVoiceController(TelnyxCallDataExtractor callDataExtractor, InboundCallService inboundCallService, PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository) {
        this.callDataExtractor = callDataExtractor;
        this.inboundCallService = inboundCallService;
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
    }
}

