/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.extractor;

import com.saas.tenant.entity.InboundCallData;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZiwoCallDataExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZiwoCallDataExtractor.class);
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_DATE_TIME;

    public InboundCallData extractFromZiwoRequest(Map<String, Object> payload) {
        InboundCallData callData = new InboundCallData();
        try {
            Integer duration;
            String endTimeStr;
            callData.setCallSid(this.getString(payload, "call_id"));
            callData.setFromNumber(this.getString(payload, "from"));
            callData.setToNumber(this.getString(payload, "to"));
            callData.setDirection(this.getString(payload, "direction", "inbound"));
            callData.setCallStatus(this.getString(payload, "status", "initiated"));
            Map callerLocation = this.getMap(payload, "caller_location");
            if (callerLocation != null) {
                callData.setFromCity(this.getString(callerLocation, "city"));
                callData.setFromState(this.getString(callerLocation, "state"));
                callData.setFromCountry(this.getString(callerLocation, "country"));
            }
            callData.setCaller(this.getString(payload, "caller_name"));
            String startTimeStr = this.getString(payload, "start_time");
            if (startTimeStr != null && !startTimeStr.isEmpty()) {
                callData.setStartTime(this.parseDateTime(startTimeStr));
            }
            if ((endTimeStr = this.getString(payload, "end_time")) != null && !endTimeStr.isEmpty()) {
                callData.setEndTime(this.parseDateTime(endTimeStr));
            }
            if ((duration = this.getInteger(payload, "duration")) != null) {
                callData.setDuration(duration);
            }
            callData.setRecordingUrl(this.getString(payload, "recording_url"));
            callData.setRecordingSid(this.getString(payload, "recording_sid"));
            log.debug("Extracted Ziwo call data: CallSid={}, From={}, To={}", new Object[]{callData.getCallSid(), callData.getFromNumber(), callData.getToNumber()});
            return callData;
        }
        catch (Exception e) {
            log.error("Error extracting Ziwo call data", (Throwable)e);
            return callData;
        }
    }

    public void updateCallDataWithEvent(InboundCallData callData, Map<String, Object> eventPayload) {
        try {
            String event = this.getString(eventPayload, "event");
            if (event == null) {
                return;
            }
            switch (event) {
                case "call.initiated": {
                    callData.setCallStatus("initiated");
                    String startTimeStr = this.getString(eventPayload, "start_time");
                    if (startTimeStr == null || startTimeStr.isEmpty()) break;
                    callData.setStartTime(this.parseDateTime(startTimeStr));
                    break;
                }
                case "call.answered": {
                    callData.setCallStatus("in-progress");
                    break;
                }
                case "call.completed": {
                    String recordingUrl;
                    Integer duration;
                    callData.setCallStatus("completed");
                    String endTimeStr = this.getString(eventPayload, "end_time");
                    if (endTimeStr != null && !endTimeStr.isEmpty()) {
                        callData.setEndTime(this.parseDateTime(endTimeStr));
                    }
                    if ((duration = this.getInteger(eventPayload, "duration")) != null) {
                        callData.setDuration(duration);
                    }
                    if ((recordingUrl = this.getString(eventPayload, "recording_url")) == null || recordingUrl.isEmpty()) break;
                    callData.setRecordingUrl(recordingUrl);
                    break;
                }
                case "call.failed": 
                case "call.no-answer": 
                case "call.busy": {
                    callData.setCallStatus(event.replace("call.", ""));
                    break;
                }
                default: {
                    log.debug("Unhandled Ziwo event type: {}", (Object)event);
                }
            }
            log.debug("Updated Ziwo call data with event: {}", (Object)event);
        }
        catch (Exception e) {
            log.error("Error updating Ziwo call data with event", (Throwable)e);
        }
    }

    private String getString(Map<String, Object> map, String key) {
        return this.getString(map, key, null);
    }

    private String getString(Map<String, Object> map, String key, String defaultValue) {
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    private Integer getInteger(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse integer value for key {}: {}", (Object)key, value);
            return null;
        }
    }

    private Map<String, Object> getMap(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value instanceof Map) {
            return (Map)value;
        }
        return null;
    }

    private LocalDateTime parseDateTime(String dateTimeStr) {
        if (dateTimeStr == null || dateTimeStr.isEmpty()) {
            return null;
        }
        try {
            return LocalDateTime.parse(dateTimeStr, ISO_FORMATTER);
        }
        catch (DateTimeParseException e) {
            log.warn("Could not parse datetime: {}", (Object)dateTimeStr);
            return null;
        }
    }
}

