# 🚀 Configuration Telnyx TeXML - Guide Complet

## Vue d'ensemble

Ce guide explique comment configurer Telnyx avec **TeXML** (compatible TwiML) pour utiliser votre API Spring Boot comme backend vocal.

**TeXML = TwiML** : Aucune modification de code nécessaire ! 🎉

---

## 📋 Prérequis

1. ✅ Compte Telnyx actif
2. ✅ Numéro de téléphone Telnyx acheté
3. ✅ API Spring Boot déployée (ou ngrok pour tests locaux)
4. ✅ Numéro ajouté dans la table `phone_numbers` avec `provider = TELNYX`

---

## 🔧 Configuration dans le Portail Telnyx

### Étape 1 : Créer une Application TeXML

1. **Connexion** : [portal.telnyx.com](https://portal.telnyx.com)

2. **Navigation** : 
   - Cliquez sur **Voice** (menu gauche)
   - Sélectionnez **Programmable Voice**
   - Cliquez sur **TeXML Applications**

3. **Créer l'application** :
   - Cliquez **"Add New Application"**
   - **Name** : `Spring Boot SaaS API`
   - **Webhook URL** : `https://votre-domaine.com/api/voip/telnyx/texml-response`
   - **HTTP Method** : `POST` (ou `POST & GET` pour flexibilité)
   - **Failover URL** (optionnel) : URL de backup si la principale échoue
   - Cliquez **Save**

### Étape 2 : Assigner le Numéro de Téléphone

1. Dans **Voice** → **Phone Numbers**
2. Trouvez votre numéro (`+18066983980`)
3. Cliquez **Edit** (icône crayon)
4. **Connection** : Sélectionnez votre application TeXML créée
5. Cliquez **Save**

---

## 🧪 Test Local avec ngrok

Pour tester localement avant le déploiement :

```bash
# 1. Lancez votre API Spring Boot
mvn spring-boot:run

# 2. Lancez ngrok (dans un autre terminal)
ngrok http 8000

# 3. Copiez l'URL HTTPS (exemple: https://abc123.ngrok.io)
# 4. Dans Telnyx Portal, configurez:
#    Webhook URL: https://abc123.ngrok.io/api/voip/telnyx/texml-response
```

---

## 🎯 Configuration de l'Assistant AI

### Option A : Telnyx Native AI (Recommandé)

1. **Créer un AI Assistant dans Telnyx** :
   - Telnyx Portal → **AI** → **Voice AI**
   - Cliquez **Create Assistant**
   - Configurez le prompt en français
   - Copiez l'**Assistant ID** (ex: `ai_12345abcde`)

2. **Configurer les variables d'environnement** :

```bash
# Dans votre .env ou Replit Secrets
TELNYX_AI_TYPE=TELNYX_NATIVE_AI
TELNYX_AI_ASSISTANT_ID=ai_12345abcde
```

3. **Redémarrez votre application**

### Option B : WebSocket Streaming (OpenAI, ElevenLabs)

Pour utiliser votre propre backend AI :

```bash
# Variables d'environnement
TELNYX_AI_TYPE=WEBSOCKET_STREAM
TELNYX_STREAM_URL=wss://votre-serveur-ai.com/stream
```

### Option C : Mode Test (Par défaut)

Sans configuration, l'API retourne un message de test en français.

---

## 📞 Exemple d'Appel - Flux Complet

```
1. Client appelle +18066983980
        ↓
2. Telnyx envoie webhook POST à votre API:
   POST /api/voip/telnyx/texml-response
   From=+33612345678
   To=+18066983980
   CallSid=CA1234567890abcdef
        ↓
3. Votre API identifie le tenant via phone_numbers
        ↓
4. Sauvegarde les données dans tenant_xxx database
        ↓
5. Retourne XML TeXML:
   <?xml version="1.0" encoding="UTF-8"?>
   <Response>
     <Start>
       <TelnyxAI assistantId="ai_12345abcde"/>
     </Start>
   </Response>
        ↓
6. Telnyx démarre l'assistant AI
        ↓
7. Conversation entre client et AI
        ↓
8. Webhook de fin d'appel avec données extraites
```

---

## 🔍 Vérification et Debug

### Test rapide

```bash
# Test endpoint
curl https://votre-domaine.com/api/voip/telnyx/texml-test

# Réponse attendue (XML):
<?xml version="1.0" encoding="UTF-8"?>
<Response>
  <Say language="fr-FR">Test TeXML - Telnyx est correctement configuré.</Say>
</Response>
```

### Logs à surveiller

```log
=== TELNYX TeXML REQUEST ===
📞 From: +33612345678, To: +18066983980, CallSid: CA123..., Status: initiated
✅ Identified Tenant: tenant_1 for Telnyx number: +18066983980
📊 Using schema: tenant_acme
✅ Telnyx call data saved to schema: tenant_acme
🤖 Starting Telnyx Native AI Assistant: ai_12345abcde
📄 TeXML Response:
<?xml version="1.0" encoding="UTF-8"?>
<Response>
  <Start>
    <TelnyxAI assistantId="ai_12345abcde"/>
  </Start>
</Response>
```

### Problèmes courants

| Problème | Solution |
|----------|----------|
| ❌ L'appel sonne mais personne ne répond | Vérifiez `TELNYX_AI_ASSISTANT_ID` est configuré |
| ❌ Message "Assistant non configuré" | Ajoutez les variables d'environnement |
| ❌ Numéro non trouvé | Ajoutez le numéro dans `phone_numbers` avec `provider=TELNYX` |
| ❌ Erreur 404 | Vérifiez l'URL du webhook dans Telnyx Portal |
| ❌ Erreur 500 | Consultez les logs Spring Boot |

---

## 📊 Ajouter le Numéro dans la Base de Données

### Via API Admin

```bash
POST https://votre-domaine.com/api/admin/phone-numbers
Authorization: Bearer <admin_token>
Content-Type: application/json

{
  "phoneNumber": "+18066983980",
  "tenantId": "tenant_1",
  "provider": "TELNYX",
  "friendlyName": "Telnyx Main Line",
  "isActive": true,
  "description": "Ligne principale Telnyx avec AI"
}
```

### Via SQL Direct

```sql
INSERT INTO phone_numbers (phone_number, tenant_id, provider, friendly_name, is_active, description)
VALUES ('+18066983980', 'tenant_1', 'TELNYX', 'Telnyx Main Line', true, 'Ligne principale avec AI');
```

---

## 🎨 Personnalisation du TeXML

Le contrôleur `TelnyxTeXMLController` génère automatiquement le XML, mais vous pouvez le personnaliser :

```java
// Exemple : Ajouter un message d'accueil personnalisé
xml.append("  <Say language=\"fr-FR\">Bonjour, bienvenue chez Dr. Martin.</Say>\n");
xml.append("  <Pause length=\"1\"/>\n");
xml.append("  <Start>\n");
xml.append("    <TelnyxAI assistantId=\"").append(aiAssistantId).append("\"/>\n");
xml.append("  </Start>\n");
```

---

## ✅ Checklist Finale

Avant votre premier appel, vérifiez :

- [ ] Application TeXML créée dans Telnyx Portal
- [ ] Webhook URL configurée : `/api/voip/telnyx/texml-response`
- [ ] Numéro assigné à l'application TeXML
- [ ] Numéro ajouté dans table `phone_numbers` (provider=TELNYX)
- [ ] Variables d'environnement configurées (`TELNYX_AI_ASSISTANT_ID`)
- [ ] API Spring Boot démarrée et accessible
- [ ] Test avec ngrok si local, ou déployé en production

---

## 📚 Ressources

- **Telnyx TeXML Docs** : https://developers.telnyx.com/docs/voice/programmable-voice/texml-setup
- **TeXML vs TwiML** : https://telnyx.com/resources/twiml-vs-texml
- **API Documentation** : Voir `API_DOCUMENTATION.md`
- **Support Telnyx** : support@telnyx.com

---

**Configuration réussie ! Votre système Telnyx est prêt à recevoir des appels ! 🎉**
