package com.saas.admin.dto.request;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Request DTO for creating a new permission
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CreatePermissionRequest {
    
    @NotBlank(message = "Resource is required")
    @Size(min = 2, max = 50, message = "Resource must be between 2 and 50 characters")
    @Pattern(regexp = "^[a-z]+$", message = "Resource must be lowercase letters only")
    private String resource;
    
    @NotBlank(message = "Action is required")
    @Size(min = 2, max = 50, message = "Action must be between 2 and 50 characters")
    @Pattern(regexp = "^[a-z]+$", message = "Action must be lowercase letters only")
    private String action;
    
    @Size(max = 500, message = "Description must not exceed 500 characters")
    private String description;
    
    private Boolean isSystem = false;
}
