package com.saas.admin.dto.request;

import com.saas.shared.enums.Provider;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Request DTO for creating tenant-specific VoIP configuration
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CreateVoipConfigRequest {
    
    @NotNull(message = "Provider is required")
    private Provider provider;
    
    /**
     * AI Assistant ID (e.g., assistant-xxx for Telnyx, agent_xxx for ElevenLabs)
     */
    private String aiAssistantId;
    
    /**
     * AI Type: TELNYX_NATIVE_AI, WEBSOCKET_STREAM, OPENAI, ELEVENLABS, etc.
     */
    private String aiType;
    
    /**
     * Messaging Profile ID for SMS (Telnyx)
     */
    private String messagingProfileId;
    
    /**
     * WebSocket Stream URL for AI processing
     */
    private String streamUrl;
    
    /**
     * Is this configuration active?
     */
    @Builder.Default
    private Boolean isActive = true;
    
    /**
     * Additional metadata (JSON format)
     */
    private String metadata;
}
