package com.saas.shared.dto.mapper;

import com.saas.admin.dto.request.CreateVoipConfigRequest;
import com.saas.admin.dto.request.UpdateVoipConfigRequest;
import com.saas.admin.dto.response.VoipConfigResponse;
import com.saas.admin.entity.TenantVoipConfig;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;

import java.util.List;

@Mapper(componentModel = "spring", nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface VoipConfigMapper {
    
    /**
     * Convert entity to response DTO
     */
    VoipConfigResponse toResponse(TenantVoipConfig entity);
    
    /**
     * Convert entity list to response list
     */
    List<VoipConfigResponse> toResponseList(List<TenantVoipConfig> entities);
    
    /**
     * Convert create request to entity
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "tenantId", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    TenantVoipConfig toEntity(CreateVoipConfigRequest request);
    
    /**
     * Update entity from update request (only non-null values)
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "tenantId", ignore = true)
    @Mapping(target = "provider", ignore = true)
    @Mapping(target = "createdAt", ignore = true)
    @Mapping(target = "updatedAt", ignore = true)
    void updateEntity(UpdateVoipConfigRequest request, @MappingTarget TenantVoipConfig entity);
}
