package com.saas.tenant.entity;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.type.SqlTypes;

import java.time.LocalDateTime;
import java.util.List;

@Entity
@Table(name = "inbound_call_data")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InboundCallData {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "call_sid", unique = true, nullable = false)
    private String callSid;

    @Column(name = "provider", length = 50)
    private String provider; // TWILIO, TELNYX, ELEVENLABS, ZIWO

    @Column(name = "account_sid")
    private String accountSid;

    @Column(name = "api_version")
    private String apiVersion;

    @Column(name = "call_status")
    private String callStatus;

    @Column(name = "direction")
    private String direction;

    @Column(name = "from_number")
    private String fromNumber;

    @Column(name = "from_city")
    private String fromCity;

    @Column(name = "from_state")
    private String fromState;

    @Column(name = "from_country")
    private String fromCountry;

    @Column(name = "from_zip")
    private String fromZip;

    @Column(name = "to_number")
    private String toNumber;

    @Column(name = "to_city")
    private String toCity;

    @Column(name = "to_state")
    private String toState;

    @Column(name = "to_country")
    private String toCountry;

    @Column(name = "to_zip")
    private String toZip;

    @Column(name = "caller")
    private String caller;

    @Column(name = "caller_city")
    private String callerCity;

    @Column(name = "caller_state")
    private String callerState;

    @Column(name = "caller_country")
    private String callerCountry;

    @Column(name = "caller_zip")
    private String callerZip;

    @Column(name = "called")
    private String called;

    @Column(name = "called_city")
    private String calledCity;

    @Column(name = "called_state")
    private String calledState;

    @Column(name = "called_country")
    private String calledCountry;

    @Column(name = "called_zip")
    private String calledZip;

    @Column(name = "forwarded_from")
    private String forwardedFrom;

    @Column(name = "stir_verstat")
    private String stirVerstat;

    @Column(name = "call_token", length = 1000)
    private String callToken;

    @Column(name = "parent_call_sid")
    private String parentCallSid;

    @Column(name = "start_time")
    private LocalDateTime startTime;

    @Column(name = "end_time")
    private LocalDateTime endTime;

    @Column(name = "duration")
    private Integer duration;

    @Column(name = "recording_url")
    private String recordingUrl;

    @Column(name = "recording_sid")
    private String recordingSid;

    // Conversation transcript (JSON array of messages)
    @JdbcTypeCode(SqlTypes.JSON)
    @Column(name = "conversation", columnDefinition = "JSON")
    private List<Object> conversation;

    @CreationTimestamp
    @Column(name = "created_at", nullable = false, updatable = false)
    private LocalDateTime createdAt;

    @UpdateTimestamp
    @Column(name = "updated_at")
    private LocalDateTime updatedAt;
}
