<?php
    $notifications = [];
    $unreadNotifications = auth()->user()->unreadNotifications;
    foreach ($unreadNotifications as $notification) {
        $notifications[] = [
            'title' => $notification->data['data']['title'],
            'message' => $notification->data['data']['message'],
            'link' => $notification->data['data']['link'],
            'unread' => true,
            'id' => $notification->id,
        ];
    }
    $trigger_class = @twMerge('size-6 max-lg:size-10 max-lg:border max-lg:dark:bg-white/[3%]', $attributes->get('class:trigger'));
?>

<div
    <?php echo e($attributes->withoutTwMergeClasses()->twMerge('notifications-wrap group hidden md:flex')); ?>

    x-data="notifications(<?php echo e(json_encode($notifications)); ?>)"
    x-init="$store.notifications.setNotifications(notifications)"
    :class="{ 'has-unread': $store.notifications.hasUnread() }"
>
    <?php if (isset($component)) { $__componentOriginal0feec11b8470b4bf00c37924b86dc0af = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0feec11b8470b4bf00c37924b86dc0af = $attributes; } ?>
<?php $component = App\View\Components\Dropdown\Dropdown::resolve(['anchor' => 'end','offsetY' => ''.e($attributes->get('dropdown-offset-y') ?? '26px').''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('dropdown.dropdown'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Dropdown\Dropdown::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['attributes' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($attributes->twMergeFor('dropdown', 'notifications-dropdown'))]); ?>
         <?php $__env->slot('trigger', null, ['class' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($trigger_class),'size' => 'none']); ?> 
            <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tabler-bell'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'notifications-bell size-5 ![animation-iteration-count:3] [transform-origin:50%_5px] group-[&.has-unread]:animate-bell-ring','stroke-width' => '1.5']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
            <span
                class="notifications-ping-wrap absolute -end-0.5 -top-1 hidden size-2 rounded bg-red-500 group-[&.has-unread]:inline-block"
                title="<?php echo e(__('This Notification Is Unread')); ?>"
            >
                <div class="notifications-ping absolute inset-0 inline-block rounded-full bg-inherit ![animation-iteration-count:10] group-[&.has-unread]:animate-ping"></div>
            </span>
         <?php $__env->endSlot(); ?>

         <?php $__env->slot('dropdown', null, ['class' => 'max-h-96 w-80 overflow-y-auto']); ?> 
            <div
                class="relative"
                x-show="$store.notifications.notifications.length && $store.notifications.hasUnread()"
            >
                <h4 class="mb-0 flex items-center justify-between gap-2 border-b px-5 py-4 text-lg">
                    <?php echo e(trans('Notifications')); ?>

                    <?php if (isset($component)) { $__componentOriginale67687e3e4e61f963b25a6bcf3983629 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale67687e3e4e61f963b25a6bcf3983629 = $attributes; } ?>
<?php $component = App\View\Components\Button::resolve(['variant' => 'ghost-shadow'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Button::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'rounded-lg bg-heading-foreground/[3%] px-3 py-1 text-2xs','@click.prevent' => '$store.notifications.markAllAsRead()']); ?>
                        <?php echo e(trans('Mark All As Read')); ?>

                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale67687e3e4e61f963b25a6bcf3983629)): ?>
<?php $attributes = $__attributesOriginale67687e3e4e61f963b25a6bcf3983629; ?>
<?php unset($__attributesOriginale67687e3e4e61f963b25a6bcf3983629); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale67687e3e4e61f963b25a6bcf3983629)): ?>
<?php $component = $__componentOriginale67687e3e4e61f963b25a6bcf3983629; ?>
<?php unset($__componentOriginale67687e3e4e61f963b25a6bcf3983629); ?>
<?php endif; ?>
                </h4>
                <ul class="notifications-list">
                    <template x-for="notification in $store.notifications.notifications.filter(notif => notif.unread)">
                        <li
                            class="header-notification-item group/item relative border-b px-5 py-4 transition-all last:border-b-0 hover:bg-heading-foreground/5"
                            :class="{ 'is-read': !notification.unread }"
                        >

                            <h5 class="relative mb-1">
                                <span x-text="notification.title"></span>
                                <span
                                    class="notifications-ping-wrap ms-2 inline-block size-2 rounded-full bg-red-500 align-super group-[&.is-read]/item:hidden"
                                    title="<?php echo e(__('Unread Notification')); ?>"
                                ></span>
                            </h5>
                            <p
                                class="mb-0 w-full overflow-hidden overflow-ellipsis whitespace-nowrap text-2xs opacity-55"
                                x-text="notification.message"
                            ></p>
                            <a
                                class="absolute inset-0 z-0 block"
                                href="#"
                                @click.prevent="$store.notifications.markThenHref(notification)"
                            ></a>
                        </li>
                    </template>
                </ul>
                <div
                    class="absolute inset-0 place-content-center bg-dropdown-background/10 backdrop-blur-sm"
                    :class="{ 'hidden': !$store.notifications.loading, 'grid': $store.notifications.loading }"
                >
                    <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tabler-loader-2'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-9 animate-spin']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
                </div>
            </div>
            <h4
                class="px-4 py-10 text-center last:mb-0"
                x-show="!$store.notifications.notifications.length || !$store.notifications.hasUnread()"
            >
                <?php echo e(trans("There's No Notifications")); ?>

            </h4>
         <?php $__env->endSlot(); ?>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0feec11b8470b4bf00c37924b86dc0af)): ?>
<?php $attributes = $__attributesOriginal0feec11b8470b4bf00c37924b86dc0af; ?>
<?php unset($__attributesOriginal0feec11b8470b4bf00c37924b86dc0af); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0feec11b8470b4bf00c37924b86dc0af)): ?>
<?php $component = $__componentOriginal0feec11b8470b4bf00c37924b86dc0af; ?>
<?php unset($__componentOriginal0feec11b8470b4bf00c37924b86dc0af); ?>
<?php endif; ?>
</div>
<?php /**PATH /home/withanouar/public_html/solvamind.ai/resources/views/default/components/notifications.blade.php ENDPATH**/ ?>