<?php
    $container_class = ['header-search-results-container max-h-[min(440px,80vh)] overflow-y-auto rounded-xl bg-background shadow-xl shadow-black/5'];

    if ($style === 'compact') {
        $container_class[] = 'absolute top-full inset-x-0 z-50 mt-4';
    }

    $container_class[] = $attributes->get('class:results-container');
?>

<div
    class="<?php echo e(@twMerge($container_class, $attributes->get('class:results-container'))); ?>"
    <?php if($style === 'compact'): ?> x-cloak
    x-transition
    x-show="modalOpen"
	@click.outside="toggleModal(false)" <?php endif; ?>
>
    <div
        class="header-search-results w-full"
        x-cloak
        x-show="doneSearching"
    >
        <h3 class="m-0 border-b py-4 ps-5 text-start text-base font-medium">
            <?php echo e(__('Search results')); ?>

        </h3>

        <!-- Search results here -->
        <div
            class="search-results-container"
            x-html="searchResults"
        ></div>
    </div>

    <div
        class="header-search-recents"
        x-cloak
        x-show="isSearching || pending"
    >
        <h3 class="m-0 w-full border-b px-5 py-4 text-start text-base font-medium">
            <?php echo e(__('Recent Search')); ?>

        </h3>

        <!-- Recent searchs -->
        <div
            class="recent-search-container flex flex-col"
            :class="{ 'no-result': recentSearchKeys.length === 0 }"
        >
            <h3 class="mb-2 hidden p-6 text-center font-medium text-heading-foreground">
                <?php echo e(__('There is no recent search.')); ?>

            </h3>

            <div class="flex flex-wrap gap-2 p-5">
                <template
                    x-for="key in recentSearchKeys"
                    :key="key.keyword || key"
                >
                    <a
                        class="flex cursor-pointer items-center gap-3 rounded-2xl border py-0.5 pe-1 ps-3 text-xs font-medium transition-all hover:border-primary hover:bg-primary hover:text-primary-foreground"
                        href="#"
                        @click.prevent="applyRecentSearch(key)"
                    >
                        <span
                            class="leading-none"
                            x-text="key.keyword || key"
                        ></span>

                        <span
                            class="inline-grid size-[18px] cursor-pointer place-items-center rounded-full transition hover:scale-110 hover:bg-background hover:text-foreground"
                            @click.prevent.stop="deleteRecentSearchKey(key)"
                        >
                            <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tabler-x'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-4 opacity-80']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
                        </span>
                    </a>
                </template>
            </div>
        </div>

        <?php if (isset($component)) { $__componentOriginale67687e3e4e61f963b25a6bcf3983629 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale67687e3e4e61f963b25a6bcf3983629 = $attributes; } ?>
<?php $component = App\View\Components\Button::resolve(['variant' => 'link','href' => ''.e(route('dashboard.user.openai.documents.all')).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Button::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-full justify-between rounded-none border-b px-5 py-4 font-heading !text-base !font-medium text-heading-foreground','style' => 'font-weight: inherit;']); ?>
            <?php echo e(__('Recently Launched')); ?>

            <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('tabler-chevron-right'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(BladeUI\Icons\Components\Svg::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'size-4']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale67687e3e4e61f963b25a6bcf3983629)): ?>
<?php $attributes = $__attributesOriginale67687e3e4e61f963b25a6bcf3983629; ?>
<?php unset($__attributesOriginale67687e3e4e61f963b25a6bcf3983629); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale67687e3e4e61f963b25a6bcf3983629)): ?>
<?php $component = $__componentOriginale67687e3e4e61f963b25a6bcf3983629; ?>
<?php unset($__componentOriginale67687e3e4e61f963b25a6bcf3983629); ?>
<?php endif; ?>

        <!-- Recent launched -->
        <div
            class="recent-lunched-container flex flex-col"
            x-html="recentLunchedDocs"
        >
            <div class="block p-6 text-center font-medium text-heading-foreground">
                <h3 class="mb-2"><?php echo e(__('There is no recent lunch.')); ?></h3>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/withanouar/public_html/solvamind.ai/resources/views/default/components/header-search/header-search-results.blade.php ENDPATH**/ ?>