<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2InfoTypeDescription extends \Google\Collection
{
  protected $collection_key = 'versions';
  protected $categoriesType = GooglePrivacyDlpV2InfoTypeCategory::class;
  protected $categoriesDataType = 'array';
  /**
   * @var string
   */
  public $description;
  /**
   * @var string
   */
  public $displayName;
  /**
   * @var string
   */
  public $example;
  protected $locationSupportType = GooglePrivacyDlpV2LocationSupport::class;
  protected $locationSupportDataType = '';
  /**
   * @var string
   */
  public $name;
  protected $sensitivityScoreType = GooglePrivacyDlpV2SensitivityScore::class;
  protected $sensitivityScoreDataType = '';
  /**
   * @var string[]
   */
  public $specificInfoTypes;
  /**
   * @var string[]
   */
  public $supportedBy;
  protected $versionsType = GooglePrivacyDlpV2VersionDescription::class;
  protected $versionsDataType = 'array';

  /**
   * @param GooglePrivacyDlpV2InfoTypeCategory[]
   */
  public function setCategories($categories)
  {
    $this->categories = $categories;
  }
  /**
   * @return GooglePrivacyDlpV2InfoTypeCategory[]
   */
  public function getCategories()
  {
    return $this->categories;
  }
  /**
   * @param string
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * @param string
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * @param string
   */
  public function setExample($example)
  {
    $this->example = $example;
  }
  /**
   * @return string
   */
  public function getExample()
  {
    return $this->example;
  }
  /**
   * @param GooglePrivacyDlpV2LocationSupport
   */
  public function setLocationSupport(GooglePrivacyDlpV2LocationSupport $locationSupport)
  {
    $this->locationSupport = $locationSupport;
  }
  /**
   * @return GooglePrivacyDlpV2LocationSupport
   */
  public function getLocationSupport()
  {
    return $this->locationSupport;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param GooglePrivacyDlpV2SensitivityScore
   */
  public function setSensitivityScore(GooglePrivacyDlpV2SensitivityScore $sensitivityScore)
  {
    $this->sensitivityScore = $sensitivityScore;
  }
  /**
   * @return GooglePrivacyDlpV2SensitivityScore
   */
  public function getSensitivityScore()
  {
    return $this->sensitivityScore;
  }
  /**
   * @param string[]
   */
  public function setSpecificInfoTypes($specificInfoTypes)
  {
    $this->specificInfoTypes = $specificInfoTypes;
  }
  /**
   * @return string[]
   */
  public function getSpecificInfoTypes()
  {
    return $this->specificInfoTypes;
  }
  /**
   * @param string[]
   */
  public function setSupportedBy($supportedBy)
  {
    $this->supportedBy = $supportedBy;
  }
  /**
   * @return string[]
   */
  public function getSupportedBy()
  {
    return $this->supportedBy;
  }
  /**
   * @param GooglePrivacyDlpV2VersionDescription[]
   */
  public function setVersions($versions)
  {
    $this->versions = $versions;
  }
  /**
   * @return GooglePrivacyDlpV2VersionDescription[]
   */
  public function getVersions()
  {
    return $this->versions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2InfoTypeDescription::class, 'Google_Service_DLP_GooglePrivacyDlpV2InfoTypeDescription');
