## Работа с персональными данными

Персональные данные пользователя — это фамилия, имя, отчество пользователя и другие данные о нём.

Персональные данные пользователя нужны для проведения выплат через СБП с проверкой получателя. [Как делать выплаты с проверкой получателя](https://yookassa.ru/developers/payouts/scenario-extensions/recipient-check)

SDK позволяет создавать персональные данные пользователя, а также получать о них информацию.

Объект персональных данных `PersonalData` содержит актуальную информацию о персональных данных пользователя, сохраненных в ЮKassa. Объект формируется при создании персональных данных и приходит в ответ на любой запрос, связанный с персональными данными пользователя.

Набор возвращаемых параметров зависит от статуса объекта (значение параметра `status`) и того, какие параметры вы передали в запросе на создание персональных данных.

* [Создание персональных данных](#Создание-персональных-данных)
* [Получить информацию о персональных данных](#Получить-информацию-о-персональных-данных)

---

### Создание персональных данных <a name="Создание-персональных-данных"></a>

Запрос позволяет создать в ЮKassa объект персональных данных. В запросе необходимо передать фамилию, имя, отчество пользователя и указать, с какой целью эти данные будут использоваться.

Идентификатор созданного объекта персональных данных необходимо использовать в запросе на проведение выплаты через СБП с проверкой получателя.

В ответ на запрос придет объект персональных данных — `PersonalDataResponse` — в актуальном статусе.

```php
require_once 'vendor/autoload.php';

$client = new \YooKassa\Client();
$client->setAuth('xxxxxx', 'test_XXXXXXX');

$request = [
    'type' => 'sbp_payout_recipient',
    'last_name' => 'Иванов',
    'first_name' => 'Иван',
    'middle_name' => 'Иванович',
    'metadata' => [
        'email' => 'i.ivanov@ivan.name',
    ],
];
$idempotenceKey = uniqid('', true);
try {
    $result = $client->createPersonalData($request, $idempotenceKey);
} catch (\Exception $e) {
    $result = $e;
}

var_dump($result);
```
---

### Получить информацию о персональных данных <a name="Получить-информацию-о-персональных-данных"></a>

С помощью этого запроса вы можете получить информацию о текущем статусе объекта персональных данных по его уникальному идентификатору.

В ответ на запрос придет объект персональных данных — `PersonalDataResponse` — в актуальном статусе.

```php
require_once 'vendor/autoload.php';

$client = new \YooKassa\Client();
$client->setAuth('xxxxxx', 'test_XXXXXXX');

$personalDataId = 'pd-285c0ab7-0003-5000-9000-0e1166498fda';
try {
    $response = $client->getPersonalDataInfo($personalDataId);
} catch (\Exception $e) {
    $response = $e;
}

var_dump($response);
```
