/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.admin.entity.Permission;
import com.saas.admin.entity.Role;
import com.saas.admin.entity.User;
import com.saas.admin.entity.UserRole;
import com.saas.admin.repository.PermissionRepository;
import com.saas.admin.repository.RolePermissionRepository;
import com.saas.admin.repository.RoleRepository;
import com.saas.admin.repository.UserRoleRepository;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleService.class);
    private final RoleRepository roleRepository;
    private final PermissionRepository permissionRepository;
    private final RolePermissionRepository rolePermissionRepository;
    private final UserRoleRepository userRoleRepository;

    @Transactional
    public Role createRole(String name, String description, boolean isSystem) {
        log.info("\ud83d\udcdd Creating role: {}", (Object)name);
        if (this.roleRepository.existsByName(name)) {
            throw new IllegalArgumentException("Role with name '" + name + "' already exists");
        }
        Role role = Role.builder().name(name.toUpperCase()).description(description).isActive(Boolean.valueOf(true)).isSystem(Boolean.valueOf(isSystem)).build();
        Role saved = (Role)this.roleRepository.save((Object)role);
        log.info("\u2705 Role created with ID: {}", (Object)saved.getId());
        return saved;
    }

    @Transactional(readOnly=true)
    public Optional<Role> getRoleById(Long id) {
        return this.roleRepository.findById((Object)id);
    }

    @Transactional(readOnly=true)
    public Optional<Role> getRoleByName(String name) {
        return this.roleRepository.findByName(name);
    }

    @Transactional(readOnly=true)
    public Optional<Role> getRoleByIdWithPermissions(Long id) {
        return this.roleRepository.findByIdWithPermissions(id);
    }

    @Transactional(readOnly=true)
    public List<Role> getAllRoles() {
        return this.roleRepository.findAll();
    }

    @Transactional(readOnly=true)
    public List<Role> getAllActiveRoles() {
        return this.roleRepository.findByIsActiveTrue();
    }

    @Transactional
    public Role updateRole(Long id, String description, Boolean isActive) {
        log.info("\u270f\ufe0f Updating role ID: {}", (Object)id);
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Role not found with ID: " + id));
        if (description != null) {
            role.setDescription(description);
        }
        if (isActive != null) {
            role.setIsActive(isActive);
        }
        Role updated = (Role)this.roleRepository.save((Object)role);
        log.info("\u2705 Role updated");
        return updated;
    }

    @Transactional
    public void deleteRole(Long id) {
        log.info("\ud83d\uddd1\ufe0f Deleting role ID: {}", (Object)id);
        Role role = (Role)this.roleRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Role not found with ID: " + id));
        if (role.getIsSystem().booleanValue()) {
            throw new IllegalStateException("Cannot delete system role: " + role.getName());
        }
        long userCount = this.userRoleRepository.countByRole(role);
        if (userCount > 0L) {
            throw new IllegalStateException("Cannot delete role assigned to " + userCount + " users. Remove user assignments first.");
        }
        this.roleRepository.delete((Object)role);
        log.info("\u2705 Role deleted");
    }

    @Transactional
    public void assignPermissionToRole(Long roleId, Long permissionId) {
        log.info("\u2795 Assigning permission {} to role {}", (Object)permissionId, (Object)roleId);
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new IllegalArgumentException("Role not found with ID: " + roleId));
        Permission permission = (Permission)this.permissionRepository.findById((Object)permissionId).orElseThrow(() -> new IllegalArgumentException("Permission not found with ID: " + permissionId));
        if (this.rolePermissionRepository.existsByRoleAndPermission(role, permission)) {
            log.warn("\u26a0\ufe0f Permission already assigned to role");
            return;
        }
        role.addPermission(permission);
        this.roleRepository.save((Object)role);
        log.info("\u2705 Permission assigned to role");
    }

    @Transactional
    public void removePermissionFromRole(Long roleId, Long permissionId) {
        log.info("\u2796 Removing permission {} from role {}", (Object)permissionId, (Object)roleId);
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new IllegalArgumentException("Role not found with ID: " + roleId));
        Permission permission = (Permission)this.permissionRepository.findById((Object)permissionId).orElseThrow(() -> new IllegalArgumentException("Permission not found with ID: " + permissionId));
        role.removePermission(permission);
        this.roleRepository.save((Object)role);
        log.info("\u2705 Permission removed from role");
    }

    @Transactional
    public void assignPermissionsToRole(Long roleId, List<Long> permissionIds) {
        log.info("\u2795 Assigning {} permissions to role {}", (Object)permissionIds.size(), (Object)roleId);
        Role role = (Role)this.roleRepository.findById((Object)roleId).orElseThrow(() -> new IllegalArgumentException("Role not found with ID: " + roleId));
        List permissions = this.permissionRepository.findByIdIn(permissionIds);
        if (permissions.size() != permissionIds.size()) {
            throw new IllegalArgumentException("Some permissions not found");
        }
        for (Permission permission : permissions) {
            if (this.rolePermissionRepository.existsByRoleAndPermission(role, permission)) continue;
            role.addPermission(permission);
        }
        this.roleRepository.save((Object)role);
        log.info("\u2705 {} permissions assigned to role", (Object)permissions.size());
    }

    @Transactional(readOnly=true)
    public List<String> getRolePermissions(Long roleId) {
        return this.rolePermissionRepository.findPermissionStringsByRoleId(roleId);
    }

    @Transactional
    public void assignRoleToUser(User user, Role role, String assignedBy) {
        log.info("\u2795 Assigning role {} to user {}", (Object)role.getName(), (Object)user.getEmail());
        if (this.userRoleRepository.existsByUserAndRole(user, role)) {
            log.warn("\u26a0\ufe0f Role already assigned to user");
            return;
        }
        UserRole userRole = UserRole.builder().user(user).role(role).assignedBy(assignedBy).build();
        this.userRoleRepository.save((Object)userRole);
        log.info("\u2705 Role assigned to user");
    }

    @Transactional
    public void removeRoleFromUser(User user, Role role) {
        log.info("\u2796 Removing role {} from user {}", (Object)role.getName(), (Object)user.getEmail());
        this.userRoleRepository.findByUserAndRole(user, role).ifPresent(arg_0 -> ((UserRoleRepository)this.userRoleRepository).delete(arg_0));
        log.info("\u2705 Role removed from user");
    }

    @Generated
    public RoleService(RoleRepository roleRepository, PermissionRepository permissionRepository, RolePermissionRepository rolePermissionRepository, UserRoleRepository userRoleRepository) {
        this.roleRepository = roleRepository;
        this.permissionRepository = permissionRepository;
        this.rolePermissionRepository = rolePermissionRepository;
        this.userRoleRepository = userRoleRepository;
    }
}

