/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.shared.audit.AuditLog;
import com.saas.shared.audit.AuditRepository;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AuditService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditService.class);
    private final AuditRepository auditRepository;
    private final ObjectMapper objectMapper;

    @Async
    public void log(String userId, String tenantId, String action, String entityType, String entityId, Object details, HttpServletRequest request) {
        try {
            String detailsJson = details != null ? this.objectMapper.writeValueAsString(details) : null;
            String ipAddress = this.getClientIpAddress(request);
            AuditLog auditLog = AuditLog.builder().userId(userId).tenantId(tenantId).action(action).entityType(entityType).entityId(entityId).details(detailsJson).ipAddress(ipAddress).build();
            this.auditRepository.save((Object)auditLog);
            log.debug("Audit log saved: {} - {} - {}", new Object[]{userId, action, entityType});
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize audit details", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Failed to save audit log", (Throwable)e);
        }
    }

    private String getClientIpAddress(HttpServletRequest request) {
        if (request == null) {
            return "UNKNOWN";
        }
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && !xForwardedFor.isEmpty()) {
            return xForwardedFor.split(",")[0].trim();
        }
        String xRealIp = request.getHeader("X-Real-IP");
        if (xRealIp != null && !xRealIp.isEmpty()) {
            return xRealIp;
        }
        return request.getRemoteAddr();
    }

    @Generated
    public AuditService(AuditRepository auditRepository, ObjectMapper objectMapper) {
        this.auditRepository = auditRepository;
        this.objectMapper = objectMapper;
    }
}

