/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.core;

import jakarta.annotation.PostConstruct;
import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class SchemaInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaInitializer.class);
    private final DataSource dataSource;
    @Value(value="${multitenancy.admin-schema}")
    private String adminSchema;

    @PostConstruct
    public void initializeSchemas() {
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            log.info("Initializing admin database: {}", (Object)this.adminSchema);
            String createSchemaSQL = String.format("CREATE DATABASE IF NOT EXISTS %s", this.adminSchema);
            statement.execute(createSchemaSQL);
            log.info("Admin database '{}' created or already exists", (Object)this.adminSchema);
            statement.execute(String.format("USE %s", this.adminSchema));
            log.info("Switched to admin database '{}'", (Object)this.adminSchema);
            log.info("Database initialization completed! Hibernate will handle table creation with ddl-auto");
        }
        catch (Exception e) {
            log.error("Failed to initialize admin database", (Throwable)e);
            throw new RuntimeException("Database initialization failed", e);
        }
    }

    @Generated
    public SchemaInitializer(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

