/*
 * Decompiled with CFR 0.152.
 */
package com.saas.tenant.controller;

import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.InboundCallData;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.service.InboundCallService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tenant/calls"})
@PreAuthorize(value="hasRole('TENANT_USER')")
public class TenantCallController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantCallController.class);
    private final InboundCallService inboundCallService;

    @GetMapping(value={"/inbound"})
    public ResponseEntity<Page<InboundCallData>> getInboundCalls(Pageable pageable) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udcde Tenant {} requesting inbound calls (page: {}, size: {})", new Object[]{tenantId, pageable.getPageNumber(), pageable.getPageSize()});
        Page inboundCalls = this.inboundCallService.getAllInboundCallsPaginated(pageable);
        return ResponseEntity.ok((Object)inboundCalls);
    }

    @GetMapping(value={"/inbound/{callSid}"})
    public ResponseEntity<InboundCallData> getInboundCallByCallSid(@PathVariable String callSid) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udd0d Tenant {} requesting inbound call: {}", (Object)tenantId, (Object)callSid);
        return this.inboundCallService.getInboundCallByCallSid(callSid).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/records"})
    public ResponseEntity<List<InboundCallRequest>> getCallRecords(@RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate, @RequestParam(required=false) String provider) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udccb Tenant {} requesting call records - provider: {}, start: {}, end: {}", new Object[]{tenantId, provider, startDate, endDate});
        List callRecords = provider != null ? this.inboundCallService.getCallRecordsByProvider(provider) : (startDate != null && endDate != null ? this.inboundCallService.getCallRecordsByDateRange(startDate, endDate) : this.inboundCallService.getAllCallRecords());
        return ResponseEntity.ok((Object)callRecords);
    }

    @GetMapping(value={"/records/{callSid}"})
    public ResponseEntity<InboundCallRequest> getCallRecordByCallSid(@PathVariable String callSid) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udd0d Tenant {} requesting call record: {}", (Object)tenantId, (Object)callSid);
        return this.inboundCallService.getCallRecordByCallSid(callSid).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/patient/{phoneNumber}"})
    public ResponseEntity<List<InboundCallRequest>> getCallRecordsByPatientPhone(@PathVariable String phoneNumber) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udcde Tenant {} requesting calls for patient: {}", (Object)tenantId, (Object)phoneNumber);
        List callRecords = this.inboundCallService.getCallRecordsByPatientPhone(phoneNumber);
        return ResponseEntity.ok((Object)callRecords);
    }

    @GetMapping(value={"/recent"})
    public ResponseEntity<List<InboundCallRequest>> getRecentCalls(@RequestParam(defaultValue="10") int limit) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udccb Tenant {} requesting {} most recent calls", (Object)tenantId, (Object)limit);
        List recentCalls = this.inboundCallService.getRecentCallRecords(limit);
        return ResponseEntity.ok((Object)recentCalls);
    }

    @GetMapping(value={"/statistics"})
    public ResponseEntity<Map<String, Object>> getCallStatistics(@RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime endDate) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udcca Tenant {} requesting call statistics", (Object)tenantId);
        List records = startDate != null && endDate != null ? this.inboundCallService.getCallRecordsByDateRange(startDate, endDate) : this.inboundCallService.getAllCallRecords();
        long totalCalls = records.size();
        long callsWithAppointments = records.stream().filter(cr -> cr.getAppointmentDateTime() != null).count();
        long totalDuration = records.stream().filter(cr -> cr.getDuration() != null && cr.getDuration() > 0).mapToLong(InboundCallRequest::getDuration).sum();
        Map<String, Long> stats = Map.of("totalCalls", totalCalls, "callsWithAppointments", callsWithAppointments, "totalDurationSeconds", totalDuration, "averageDurationSeconds", totalCalls > 0L ? totalDuration / totalCalls : 0L);
        return ResponseEntity.ok(stats);
    }

    @Generated
    public TenantCallController(InboundCallService inboundCallService) {
        this.inboundCallService = inboundCallService;
    }
}

