/*
 * Decompiled with CFR 0.152.
 */
package com.saas.tenant.repository;

import com.saas.tenant.entity.CallCostRecord;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CallCostRecordRepository
extends JpaRepository<CallCostRecord, Long> {
    public Optional<CallCostRecord> findByCallSid(String var1);

    public List<CallCostRecord> findByProvider(String var1);

    public List<CallCostRecord> findByCallStartTimeBetween(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT SUM(c.cost) FROM CallCostRecord c WHERE c.callStartTime BETWEEN :start AND :end")
    public BigDecimal getTotalCostBetween(@Param(value="start") LocalDateTime var1, @Param(value="end") LocalDateTime var2);

    @Query(value="SELECT c.provider, SUM(c.cost) FROM CallCostRecord c WHERE c.callStartTime BETWEEN :start AND :end GROUP BY c.provider")
    public List<Object[]> getCostByProviderBetween(@Param(value="start") LocalDateTime var1, @Param(value="end") LocalDateTime var2);

    @Query(value="SELECT COUNT(c) FROM CallCostRecord c WHERE c.callStartTime BETWEEN :start AND :end")
    public Long getCallCountBetween(@Param(value="start") LocalDateTime var1, @Param(value="end") LocalDateTime var2);
}

