/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.Provider;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.repository.InboundCallRequestRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/ziwo"})
public class ZiwoSmsCallbackController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZiwoSmsCallbackController.class);
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;
    private final InboundCallRequestRepository inboundCallRequestRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/sms/status-callback"})
    public ResponseEntity<Map<String, Object>> handleSmsStatusCallback(@RequestBody Map<String, Object> payload) {
        ResponseEntity responseEntity;
        String fromNumber;
        log.info("Received Ziwo SMS status callback: {}", payload);
        String messageSid = payload.get("message_id") != null ? payload.get("message_id").toString() : null;
        String smsStatus = payload.get("status") != null ? payload.get("status").toString() : null;
        String string = fromNumber = payload.get("from") != null ? payload.get("from").toString() : null;
        if (messageSid == null || smsStatus == null) {
            log.warn("Missing message_id or status in Ziwo SMS callback");
            return ResponseEntity.badRequest().body(Map.of("error", "Missing required fields"));
        }
        if (fromNumber == null || fromNumber.isEmpty()) {
            log.warn("No 'from' number in Ziwo SMS callback");
            return ResponseEntity.badRequest().body(Map.of("error", "Missing 'from' number"));
        }
        TenantContext.clear();
        Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(fromNumber);
        if (!phoneOpt.isPresent() || ((PhoneNumber)phoneOpt.get()).getProvider() != Provider.ZIWO) {
            log.warn("No Ziwo phone number found for SMS from: {}", (Object)fromNumber);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Map.of("error", "Phone number not configured"));
        }
        PhoneNumber phoneNumber = (PhoneNumber)phoneOpt.get();
        String tenantId = phoneNumber.getTenantId();
        Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
        if (!tenantOpt.isPresent()) {
            log.error("Tenant not found for phone number: {}", (Object)fromNumber);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Map.of("error", "Tenant not found"));
        }
        Tenant tenant = (Tenant)tenantOpt.get();
        String schemaName = tenant.getSchemaName();
        TenantContext.setTenantId((String)schemaName);
        log.info("Set tenant context for Ziwo SMS callback: {}", (Object)schemaName);
        try {
            Optional requestOpt = this.inboundCallRequestRepository.findBySmsSid(messageSid);
            if (requestOpt.isPresent()) {
                InboundCallRequest request = (InboundCallRequest)requestOpt.get();
                request.setSmsStatus(smsStatus);
                this.inboundCallRequestRepository.save((Object)request);
                log.info("Updated SMS status to '{}' for messageSid: {}", (Object)smsStatus, (Object)messageSid);
            } else {
                log.warn("No InboundCallRequest found for Ziwo messageSid: {}", (Object)messageSid);
            }
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "success");
            response.put("message", "SMS status updated");
            responseEntity = ResponseEntity.ok(response);
        }
        catch (Throwable throwable) {
            try {
                TenantContext.clear();
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error handling Ziwo SMS status callback", (Throwable)e);
                TenantContext.clear();
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Internal server error"));
            }
        }
        TenantContext.clear();
        return responseEntity;
    }

    @Generated
    public ZiwoSmsCallbackController(PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository, InboundCallRequestRepository inboundCallRequestRepository) {
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
        this.inboundCallRequestRepository = inboundCallRequestRepository;
    }
}

