/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.saas.voip.config.VoiceAiConfig;
import com.saas.voip.handler.AiSessionHandler;
import com.saas.voip.handler.ElevenLabsSessionHandler;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.java_websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

@Component
public class ElevenLabsSessionHandler
implements AiSessionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ElevenLabsSessionHandler.class);
    private final VoiceAiConfig voiceAiConfig;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, WebSocketClient> elevenLabsClients = new ConcurrentHashMap();
    private final Map<String, StringBuilder> sessionTranscripts = new ConcurrentHashMap();
    private final Map<String, String> sessionCallSids = new ConcurrentHashMap();
    private final Map<String, String> sessionStreamIds = new ConcurrentHashMap();
    private final Map<String, String> conversationIdToCallSid = new ConcurrentHashMap();
    private final Map<String, String> conversationIdToSessionId = new ConcurrentHashMap();

    public void onClientConnect(WebSocketSession session, String streamSid, String callSid, String fromNumber, String toNumber) throws Exception {
        log.info("ElevenLabs handler - Client connected: streamSid={}, callSid={}", (Object)streamSid, (Object)callSid);
        this.sessionStreamIds.put(session.getId(), streamSid);
        this.sessionCallSids.put(session.getId(), callSid);
        this.sessionTranscripts.put(session.getId(), new StringBuilder());
        this.connectToElevenLabs(session);
    }

    private void connectToElevenLabs(WebSocketSession twilioSession) {
        try {
            String wsUrl = this.voiceAiConfig.getElevenlabs().getWsUrl();
            String agentId = this.voiceAiConfig.getElevenlabs().getAgentId();
            String wsUrlWithAgent = wsUrl + "?agent_id=" + agentId;
            log.debug("Connecting to ElevenLabs with URL: {}", (Object)wsUrlWithAgent);
            1 elevenLabsClient = new /* Unavailable Anonymous Inner Class!! */;
            String apiKey = this.voiceAiConfig.getElevenlabs().getApiKey();
            elevenLabsClient.addHeader("xi-api-key", apiKey);
            elevenLabsClient.connect();
            this.elevenLabsClients.put(twilioSession.getId(), elevenLabsClient);
        }
        catch (Exception e) {
            log.error("Failed to connect to ElevenLabs", (Throwable)e);
        }
    }

    private void initializeConversation(WebSocketClient client, String agentId) {
        try {
            ObjectNode initMessage = this.objectMapper.createObjectNode();
            initMessage.put("type", "conversation_initiation_client_data");
            ObjectNode conversationConfig = initMessage.putObject("conversation_config_override");
            ObjectNode tts = conversationConfig.putObject("tts");
            tts.put("output_format", "ulaw_8000");
            String message = this.objectMapper.writeValueAsString((Object)initMessage);
            log.debug("Initializing ElevenLabs conversation with mulaw 8kHz output: {}", (Object)message);
            client.send(message);
        }
        catch (Exception e) {
            log.error("Error initializing ElevenLabs conversation", (Throwable)e);
        }
    }

    public void onMediaFrame(WebSocketSession session, String payload) throws Exception {
        JsonNode mediaNode = this.objectMapper.readTree(payload);
        if (mediaNode.has("media") && mediaNode.get("media").has("payload")) {
            String audioPayload = mediaNode.get("media").get("payload").asText();
            this.sendAudioToElevenLabs(session, audioPayload);
        }
    }

    private void sendAudioToElevenLabs(WebSocketSession twilioSession, String audioBase64) {
        try {
            WebSocketClient client = (WebSocketClient)this.elevenLabsClients.get(twilioSession.getId());
            if (client != null && client.isOpen()) {
                String pcmBase64 = this.convertMulawToPcm(audioBase64);
                ObjectNode audioMessage = this.objectMapper.createObjectNode();
                audioMessage.put("user_audio_chunk", pcmBase64);
                String message = this.objectMapper.writeValueAsString((Object)audioMessage);
                log.debug("\ud83d\udce3 Sending user audio to ElevenLabs: {} bytes PCM 16kHz (upsampled from {} bytes mulaw 8kHz)", (Object)pcmBase64.length(), (Object)audioBase64.length());
                client.send(message);
                log.debug("\u2705 User audio sent to ElevenLabs successfully");
            } else {
                log.warn("\u26a0\ufe0f Cannot send audio to ElevenLabs: client is null or closed");
            }
        }
        catch (Exception e) {
            log.error("\u274c Error sending audio to ElevenLabs", (Throwable)e);
        }
    }

    private String convertMulawToPcm(String mulawBase64) {
        try {
            byte[] mulawBytes = Base64.getDecoder().decode(mulawBase64);
            short[] pcm8kSamples = new short[mulawBytes.length];
            for (int i = 0; i < mulawBytes.length; ++i) {
                pcm8kSamples[i] = this.mulawToLinear(mulawBytes[i]);
            }
            short[] pcm16kSamples = new short[pcm8kSamples.length * 2];
            for (int i = 0; i < pcm8kSamples.length; ++i) {
                pcm16kSamples[i * 2] = pcm8kSamples[i];
                pcm16kSamples[i * 2 + 1] = pcm8kSamples[i];
            }
            byte[] pcmBytes = new byte[pcm16kSamples.length * 2];
            for (int i = 0; i < pcm16kSamples.length; ++i) {
                pcmBytes[i * 2] = (byte)(pcm16kSamples[i] & 0xFF);
                pcmBytes[i * 2 + 1] = (byte)(pcm16kSamples[i] >> 8 & 0xFF);
            }
            return Base64.getEncoder().encodeToString(pcmBytes);
        }
        catch (Exception e) {
            log.error("Error converting mulaw to PCM", (Throwable)e);
            return mulawBase64;
        }
    }

    private short mulawToLinear(byte mulawByte) {
        int mulaw = ~mulawByte & 0xFF;
        int sign = (mulaw & 0x80) >> 7;
        int exponent = (mulaw & 0x70) >> 4;
        int mantissa = mulaw & 0xF;
        int linear = (mantissa << 3) + 132 << exponent;
        linear -= 132;
        if (sign == 1) {
            linear = -linear;
        }
        return (short)linear;
    }

    private void handleElevenLabsMessage(WebSocketSession twilioSession, String message) {
        try {
            String transcript;
            JsonNode audioEvent;
            JsonNode metadataEvent;
            JsonNode response = this.objectMapper.readTree(message);
            String type = response.has("type") ? response.get("type").asText() : "";
            log.debug("Received ElevenLabs event: {}", (Object)type);
            if ("audio".equals(type) || "conversation_initiation_metadata".equals(type)) {
                log.debug("\ud83d\udd0d Full {} message: {}", (Object)type, (Object)message);
            }
            if ("conversation_initiation_metadata".equals(type) && response.has("conversation_initiation_metadata_event") && (metadataEvent = response.get("conversation_initiation_metadata_event")).has("conversation_id")) {
                String conversationId = metadataEvent.get("conversation_id").asText();
                String callSid = (String)this.sessionCallSids.get(twilioSession.getId());
                if (callSid != null) {
                    this.conversationIdToCallSid.put(conversationId, callSid);
                    this.conversationIdToSessionId.put(conversationId, twilioSession.getId());
                    log.info("\ud83d\udcdd Stored conversation mapping: {} \u2192 callSid: {}", (Object)conversationId, (Object)callSid);
                }
            }
            if ("audio".equals(type) && response.has("audio_event") && (audioEvent = response.get("audio_event")).has("audio_base_64")) {
                String audioBase64 = audioEvent.get("audio_base_64").asText();
                log.debug("Received audio from ElevenLabs, length: {} bytes", (Object)audioBase64.length());
                this.sendAudioToTwilio(twilioSession, audioBase64);
            }
            if ("user_transcript".equals(type) && response.has("user_transcript")) {
                transcript = response.get("user_transcript").asText();
                log.info("User said: {}", (Object)transcript);
                this.appendTranscript(twilioSession.getId(), "user", transcript);
            }
            if ("agent_response".equals(type) && response.has("agent_response")) {
                transcript = response.get("agent_response").asText();
                log.info("Agent said: {}", (Object)transcript);
                this.appendTranscript(twilioSession.getId(), "assistant", transcript);
            }
            if ("interruption".equals(type)) {
                log.info("User interrupted the agent");
            }
        }
        catch (Exception e) {
            log.error("Error processing ElevenLabs message", (Throwable)e);
        }
    }

    private void sendAudioToTwilio(WebSocketSession twilioSession, String audioBase64) {
        try {
            if (!twilioSession.isOpen()) {
                log.warn("\u26a0\ufe0f Twilio session is closed, cannot send audio");
                return;
            }
            String streamSid = (String)this.sessionStreamIds.get(twilioSession.getId());
            if (streamSid == null) {
                log.error("\u274c No streamSid found for session {}", (Object)twilioSession.getId());
                return;
            }
            String mulawBase64 = this.convertPcm16kToMulaw8k(audioBase64);
            ObjectNode mediaMessage = this.objectMapper.createObjectNode();
            mediaMessage.put("event", "media");
            mediaMessage.put("streamSid", streamSid);
            ObjectNode media = this.objectMapper.createObjectNode();
            media.put("payload", mulawBase64);
            mediaMessage.set("media", (JsonNode)media);
            String messageJson = this.objectMapper.writeValueAsString((Object)mediaMessage);
            log.debug("\ud83d\udce4 Sending {} bytes of mulaw audio to Twilio (converted from {} bytes PCM, streamSid: {})", new Object[]{mulawBase64.length(), audioBase64.length(), streamSid});
            twilioSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)messageJson));
            log.debug("\u2705 Audio sent to Twilio successfully");
        }
        catch (Exception e) {
            log.error("\u274c Error sending audio to Twilio", (Throwable)e);
        }
    }

    private String convertPcm16kToMulaw8k(String pcmBase64) {
        try {
            int sampleIndex;
            byte[] pcm16k = Base64.getDecoder().decode(pcmBase64);
            int numSamples = pcm16k.length / 2;
            int outputSamples = numSamples / 2;
            byte[] mulaw8k = new byte[outputSamples];
            for (int i = 0; i < outputSamples && (sampleIndex = i * 4) + 1 < pcm16k.length; ++i) {
                int lowByte = pcm16k[sampleIndex] & 0xFF;
                byte highByte = pcm16k[sampleIndex + 1];
                int sample = highByte << 8 | lowByte;
                mulaw8k[i] = this.linearToMulaw(sample);
            }
            return Base64.getEncoder().encodeToString(mulaw8k);
        }
        catch (Exception e) {
            log.error("Error converting PCM to mulaw", (Throwable)e);
            return pcmBase64;
        }
    }

    private byte linearToMulaw(int pcmSample) {
        int MULAW_BIAS = 132;
        int MULAW_CLIP = 32635;
        int sign = pcmSample >> 8 & 0x80;
        if (sign != 0) {
            pcmSample = -pcmSample;
        }
        if (pcmSample > 32635) {
            pcmSample = 32635;
        }
        pcmSample += 132;
        int exponent = 7;
        int mask = 16384;
        while ((pcmSample & mask) == 0 && exponent > 0) {
            --exponent;
            mask >>= 1;
        }
        int mantissa = pcmSample >> exponent + 3 & 0xF;
        int mulawByte = ~(sign | exponent << 4 | mantissa);
        return (byte)(mulawByte & 0xFF);
    }

    private void appendTranscript(String sessionId, String role, String text) {
        StringBuilder transcript = (StringBuilder)this.sessionTranscripts.get(sessionId);
        if (transcript != null) {
            if (transcript.length() > 0) {
                transcript.append(", ");
            }
            transcript.append(String.format("{\"role\": \"%s\", \"content\": \"%s\"}", role, text.replace("\"", "\\\"")));
        }
    }

    public void onMark(WebSocketSession session, Map<String, Object> markData) throws Exception {
        log.debug("Mark event received (no action required for ElevenLabs)");
    }

    public void onClose(WebSocketSession session) throws Exception {
        log.info("ElevenLabs handler - Closing session: {}", (Object)session.getId());
        WebSocketClient client = (WebSocketClient)this.elevenLabsClients.remove(session.getId());
        if (client != null && client.isOpen()) {
            client.close();
        }
        this.sessionTranscripts.remove(session.getId());
        this.sessionCallSids.remove(session.getId());
    }

    public boolean supportsStructuredExtraction() {
        return false;
    }

    public Map<String, Object> buildStructuredPayload(String transcript) {
        return new HashMap<String, Object>();
    }

    public String getTranscript(String sessionId) {
        StringBuilder transcript = (StringBuilder)this.sessionTranscripts.get(sessionId);
        if (transcript != null && transcript.length() > 0) {
            return "[" + transcript.toString() + "]";
        }
        return null;
    }

    public String getCallSid(String sessionId) {
        return (String)this.sessionCallSids.get(sessionId);
    }

    public String getCallSidByConversationId(String conversationId) {
        return (String)this.conversationIdToCallSid.get(conversationId);
    }

    public String getTranscriptByConversationId(String conversationId) {
        String sessionId = (String)this.conversationIdToSessionId.get(conversationId);
        if (sessionId != null) {
            return this.getTranscript(sessionId);
        }
        return null;
    }

    @Generated
    public ElevenLabsSessionHandler(VoiceAiConfig voiceAiConfig) {
        this.voiceAiConfig = voiceAiConfig;
    }
}

