/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import com.twilio.Twilio;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.rest.api.v2010.account.MessageCreator;
import com.twilio.type.PhoneNumber;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TwilioSmsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwilioSmsService.class);
    @Value(value="${twilio.account.sid}")
    private String accountSid;
    @Value(value="${twilio.auth.token}")
    private String authToken;
    @Value(value="${twilio.phone.number}")
    private String twilioPhoneNumber;

    @PostConstruct
    public void init() {
        Twilio.init((String)this.accountSid, (String)this.authToken);
        log.info("Twilio SMS Service initialized with number: {}", (Object)this.twilioPhoneNumber);
    }

    public String sendAppointmentConfirmationSms(String toPhoneNumber, String patientName, String doctorName, LocalDateTime appointmentDateTime, String statusCallbackUrl) {
        try {
            if (appointmentDateTime == null) {
                log.warn("\u26a0\ufe0f Appointment date/time is null, cannot send SMS to {}", (Object)toPhoneNumber);
                return null;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE dd MMMM yyyy '\u00e0' HH'h'mm", Locale.FRENCH);
            String formattedDateTime = appointmentDateTime.format(formatter);
            String messageBody = String.format("\u2705 Confirmation de rendez-vous - Clinique La Rive Bleue\n\nBonjour %s,\n\nVotre rendez-vous avec %s est confirm\u00e9 pour le %s.\n\nMerci de votre confiance.\n\nClinique La Rive Bleue", patientName, doctorName, formattedDateTime);
            MessageCreator messageCreator = Message.creator((PhoneNumber)new PhoneNumber(toPhoneNumber), (PhoneNumber)new PhoneNumber(this.twilioPhoneNumber), (String)messageBody);
            if (statusCallbackUrl != null && !statusCallbackUrl.isEmpty()) {
                try {
                    messageCreator.setStatusCallback(URI.create(statusCallbackUrl));
                    log.debug("\ud83d\udccd SMS Status Callback URL set: {}", (Object)statusCallbackUrl);
                }
                catch (Exception e) {
                    log.warn("Failed to set status callback URL: {}", (Object)statusCallbackUrl);
                }
            }
            Message message = (Message)messageCreator.create();
            log.info("\ud83d\udce8 SMS envoy\u00e9 avec succ\u00e8s ! SID: {} | Statut: {} | Destinataire: {}", new Object[]{message.getSid(), message.getStatus(), toPhoneNumber});
            return message.getSid();
        }
        catch (Exception e) {
            log.error("\u274c Erreur lors de l'envoi du SMS \u00e0 {}: {}", new Object[]{toPhoneNumber, e.getMessage(), e});
            return null;
        }
    }

    public boolean sendCustomSms(String toPhoneNumber, String messageBody) {
        try {
            Message message = (Message)Message.creator((PhoneNumber)new PhoneNumber(toPhoneNumber), (PhoneNumber)new PhoneNumber(this.twilioPhoneNumber), (String)messageBody).create();
            log.info("\ud83d\udce8 SMS personnalis\u00e9 envoy\u00e9 ! SID: {} | Destinataire: {}", (Object)message.getSid(), (Object)toPhoneNumber);
            return true;
        }
        catch (Exception e) {
            log.error("\u274c Erreur lors de l'envoi du SMS personnalis\u00e9: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

