# Fix pour "Data too long for column 'to_number'"

## Problème
Les numéros Telnyx utilisent des identifiants longs comme :
```
v3:qg18_QgOdwtbMq9OkpQg2OxdR5Cb64sNte5kEA29czySKxS8TMAPEQ
```

La migration V6 originale avait `VARCHAR(50)` → trop court !

## Solution Appliquée
Migration V6 corrigée avec `VARCHAR(255)` pour tous les champs.

## Comment Corriger Votre Base Locale

### Option 1 : Drop & Recreate (Recommandé si table vide)
```sql
USE saas_db;
DROP TABLE IF EXISTS inbound_call_data;
DELETE FROM flyway_schema_history WHERE version = '6';
```
Puis redémarrez Spring Boot → migration V6 sera ré-exécutée avec les bonnes tailles.

### Option 2 : Alter Table (Si vous avez des données)
```sql
USE saas_db;

ALTER TABLE inbound_call_data 
  MODIFY COLUMN from_number VARCHAR(255),
  MODIFY COLUMN to_number VARCHAR(255),
  MODIFY COLUMN caller VARCHAR(255),
  MODIFY COLUMN called VARCHAR(255),
  MODIFY COLUMN forwarded_from VARCHAR(255);
```

### Vérification
```sql
DESCRIBE inbound_call_data;
-- Tous les champs de numéros doivent montrer VARCHAR(255)
```

## Test Après Correction

1. Redémarrez Spring Boot
2. Passez un appel Telnyx
3. Vérifiez les logs :
```
✅ [1/2] Call data saved to ADMIN database (saas_db)
✅ [2/2] Call data saved to TENANT database
🎯 SUCCESS: Call data saved to BOTH databases
```

4. Vérifiez les données :
```sql
-- Admin DB
SELECT * FROM saas_db.inbound_call_data WHERE provider = 'TELNYX' ORDER BY created_at DESC LIMIT 1;

-- Tenant DB
SELECT * FROM tenant_clinique_la_rive1_bleue1.inbound_call_data WHERE provider = 'TELNYX' ORDER BY created_at DESC LIMIT 1;
```

Les deux requêtes doivent retourner le même appel avec `provider = 'TELNYX'`.

---

**Note** : Le problème n'était PAS dans la logique du code (qui est validée par l'architecte ✅), mais dans la TAILLE des colonnes de la migration SQL V6.
