package com.saas.admin.dto.request;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Request DTO for updating tenant-specific VoIP configuration
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UpdateVoipConfigRequest {
    
    /**
     * AI Assistant ID (optional - null means no change)
     */
    private String aiAssistantId;
    
    /**
     * AI Type (optional - null means no change)
     */
    private String aiType;
    
    /**
     * Messaging Profile ID (optional - null means no change)
     */
    private String messagingProfileId;
    
    /**
     * WebSocket Stream URL (optional - null means no change)
     */
    private String streamUrl;
    
    /**
     * Active status (optional - null means no change)
     */
    private Boolean isActive;
    
    /**
     * Metadata (optional - null means no change)
     */
    private String metadata;
}
