package com.saas.tenant.entity;

import jakarta.persistence.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

import java.time.LocalDateTime;

@Entity
@Table(name = "schema_version")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SchemaVersion {
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    
    @Column(name = "version_hash", nullable = false, unique = true, length = 64)
    private String versionHash;
    
    @Column(name = "entity_count", nullable = false)
    private Integer entityCount;
    
    @Column(name = "entity_names", columnDefinition = "TEXT")
    private String entityNames;
    
    @Column(name = "migration_type", length = 50)
    private String migrationType;
    
    @Column(name = "migration_status", length = 50)
    private String migrationStatus;
    
    @Column(name = "migration_notes", columnDefinition = "TEXT")
    private String migrationNotes;
    
    @Column(name = "is_current", nullable = false)
    private Boolean isCurrent = true;
    
    @CreationTimestamp
    @Column(name = "applied_at", nullable = false, updatable = false)
    private LocalDateTime appliedAt;
    
    @UpdateTimestamp
    @Column(name = "updated_at")
    private LocalDateTime updatedAt;
    
    @Column(name = "applied_by", length = 100)
    private String appliedBy;
}
